package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetNamespaceListBuilder extends NetNamespaceListFluentImpl<NetNamespaceListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.NetNamespaceList,io.fabric8.openshift.api.model.NetNamespaceListBuilder>{
  public NetNamespaceListBuilder() {
    this(false);
  }
  public NetNamespaceListBuilder(Boolean validationEnabled) {
    this(new NetNamespaceList(), validationEnabled);
  }
  public NetNamespaceListBuilder(NetNamespaceListFluent<?> fluent) {
    this(fluent, false);
  }
  public NetNamespaceListBuilder(io.fabric8.openshift.api.model.NetNamespaceListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetNamespaceList(), validationEnabled);
  }
  public NetNamespaceListBuilder(io.fabric8.openshift.api.model.NetNamespaceListFluent<?> fluent,io.fabric8.openshift.api.model.NetNamespaceList instance) {
    this(fluent, instance, false);
  }
  public NetNamespaceListBuilder(io.fabric8.openshift.api.model.NetNamespaceListFluent<?> fluent,io.fabric8.openshift.api.model.NetNamespaceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetNamespaceListBuilder(io.fabric8.openshift.api.model.NetNamespaceList instance) {
    this(instance,false);
  }
  public NetNamespaceListBuilder(io.fabric8.openshift.api.model.NetNamespaceList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.NetNamespaceListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.NetNamespaceList build() {
    NetNamespaceList buildable = new NetNamespaceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}