package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LifecycleHookBuilder extends LifecycleHookFluentImpl<LifecycleHookBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.LifecycleHook,LifecycleHookBuilder>{
  public LifecycleHookBuilder() {
    this(false);
  }
  public LifecycleHookBuilder(Boolean validationEnabled) {
    this(new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHookFluent<?> fluent) {
    this(fluent, false);
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHookFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LifecycleHook(), validationEnabled);
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHookFluent<?> fluent,io.fabric8.openshift.api.model.LifecycleHook instance) {
    this(fluent, instance, false);
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHookFluent<?> fluent,io.fabric8.openshift.api.model.LifecycleHook instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExecNewPod(instance.getExecNewPod()); 
    fluent.withFailurePolicy(instance.getFailurePolicy()); 
    fluent.withTagImages(instance.getTagImages()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHook instance) {
    this(instance,false);
  }
  public LifecycleHookBuilder(io.fabric8.openshift.api.model.LifecycleHook instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExecNewPod(instance.getExecNewPod()); 
    this.withFailurePolicy(instance.getFailurePolicy()); 
    this.withTagImages(instance.getTagImages()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.LifecycleHookFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.LifecycleHook build() {
    LifecycleHook buildable = new LifecycleHook(fluent.getExecNewPod(),fluent.getFailurePolicy(),fluent.getTagImages());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}