package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LDAPAttributeMappingBuilder extends LDAPAttributeMappingFluentImpl<LDAPAttributeMappingBuilder> implements VisitableBuilder<LDAPAttributeMapping,io.fabric8.openshift.api.model.LDAPAttributeMappingBuilder>{
  public LDAPAttributeMappingBuilder() {
    this(false);
  }
  public LDAPAttributeMappingBuilder(Boolean validationEnabled) {
    this(new LDAPAttributeMapping(), validationEnabled);
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMappingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new LDAPAttributeMapping(), validationEnabled);
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMappingFluent<?> fluent,io.fabric8.openshift.api.model.LDAPAttributeMapping instance) {
    this(fluent, instance, false);
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMappingFluent<?> fluent,io.fabric8.openshift.api.model.LDAPAttributeMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEmail(instance.getEmail()); 
    fluent.withId(instance.getId()); 
    fluent.withName(instance.getName()); 
    fluent.withPreferredUsername(instance.getPreferredUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMapping instance) {
    this(instance,false);
  }
  public LDAPAttributeMappingBuilder(io.fabric8.openshift.api.model.LDAPAttributeMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEmail(instance.getEmail()); 
    this.withId(instance.getId()); 
    this.withName(instance.getName()); 
    this.withPreferredUsername(instance.getPreferredUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.LDAPAttributeMappingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.LDAPAttributeMapping build() {
    LDAPAttributeMapping buildable = new LDAPAttributeMapping(fluent.getEmail(),fluent.getId(),fluent.getName(),fluent.getPreferredUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}