package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KubevirtPlatformStatusBuilder extends KubevirtPlatformStatusFluentImpl<KubevirtPlatformStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.KubevirtPlatformStatus,io.fabric8.openshift.api.model.KubevirtPlatformStatusBuilder>{
  public KubevirtPlatformStatusBuilder() {
    this(false);
  }
  public KubevirtPlatformStatusBuilder(Boolean validationEnabled) {
    this(new KubevirtPlatformStatus(), validationEnabled);
  }
  public KubevirtPlatformStatusBuilder(KubevirtPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KubevirtPlatformStatus(), validationEnabled);
  }
  public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.KubevirtPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.KubevirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    fluent.withIngressIP(instance.getIngressIP()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatus instance) {
    this(instance,false);
  }
  public KubevirtPlatformStatusBuilder(io.fabric8.openshift.api.model.KubevirtPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiServerInternalIP(instance.getApiServerInternalIP()); 
    this.withIngressIP(instance.getIngressIP()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.KubevirtPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.KubevirtPlatformStatus build() {
    KubevirtPlatformStatus buildable = new KubevirtPlatformStatus(fluent.getApiServerInternalIP(),fluent.getIngressIP());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}