package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class KeystoneIdentityProviderBuilder extends KeystoneIdentityProviderFluentImpl<KeystoneIdentityProviderBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.KeystoneIdentityProvider,io.fabric8.openshift.api.model.KeystoneIdentityProviderBuilder>{
  public KeystoneIdentityProviderBuilder() {
    this(false);
  }
  public KeystoneIdentityProviderBuilder(Boolean validationEnabled) {
    this(new KeystoneIdentityProvider(), validationEnabled);
  }
  public KeystoneIdentityProviderBuilder(KeystoneIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public KeystoneIdentityProviderBuilder(io.fabric8.openshift.api.model.KeystoneIdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new KeystoneIdentityProvider(), validationEnabled);
  }
  public KeystoneIdentityProviderBuilder(io.fabric8.openshift.api.model.KeystoneIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.KeystoneIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public KeystoneIdentityProviderBuilder(io.fabric8.openshift.api.model.KeystoneIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.KeystoneIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withDomainName(instance.getDomainName()); 
    fluent.withTlsClientCert(instance.getTlsClientCert()); 
    fluent.withTlsClientKey(instance.getTlsClientKey()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public KeystoneIdentityProviderBuilder(io.fabric8.openshift.api.model.KeystoneIdentityProvider instance) {
    this(instance,false);
  }
  public KeystoneIdentityProviderBuilder(io.fabric8.openshift.api.model.KeystoneIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withDomainName(instance.getDomainName()); 
    this.withTlsClientCert(instance.getTlsClientCert()); 
    this.withTlsClientKey(instance.getTlsClientKey()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.KeystoneIdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.KeystoneIdentityProvider build() {
    KeystoneIdentityProvider buildable = new KeystoneIdentityProvider(fluent.getCa(),fluent.getDomainName(),fluent.getTlsClientCert(),fluent.getTlsClientKey(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}