package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureSpecBuilder extends InfrastructureSpecFluentImpl<InfrastructureSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.InfrastructureSpec,io.fabric8.openshift.api.model.InfrastructureSpecBuilder>{
  public InfrastructureSpecBuilder() {
    this(false);
  }
  public InfrastructureSpecBuilder(Boolean validationEnabled) {
    this(new InfrastructureSpec(), validationEnabled);
  }
  public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new InfrastructureSpec(), validationEnabled);
  }
  public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureSpec instance) {
    this(fluent, instance, false);
  }
  public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCloudConfig(instance.getCloudConfig()); 
    fluent.withPlatformSpec(instance.getPlatformSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpec instance) {
    this(instance,false);
  }
  public InfrastructureSpecBuilder(io.fabric8.openshift.api.model.InfrastructureSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCloudConfig(instance.getCloudConfig()); 
    this.withPlatformSpec(instance.getPlatformSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.InfrastructureSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.InfrastructureSpec build() {
    InfrastructureSpec buildable = new InfrastructureSpec(fluent.getCloudConfig(),fluent.getPlatformSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}