package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class InfrastructureListBuilder extends InfrastructureListFluentImpl<InfrastructureListBuilder> implements VisitableBuilder<InfrastructureList,io.fabric8.openshift.api.model.InfrastructureListBuilder>{
  public InfrastructureListBuilder() {
    this(false);
  }
  public InfrastructureListBuilder(Boolean validationEnabled) {
    this(new InfrastructureList(), validationEnabled);
  }
  public InfrastructureListBuilder(InfrastructureListFluent<?> fluent) {
    this(fluent, false);
  }
  public InfrastructureListBuilder(io.fabric8.openshift.api.model.InfrastructureListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new InfrastructureList(), validationEnabled);
  }
  public InfrastructureListBuilder(io.fabric8.openshift.api.model.InfrastructureListFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureList instance) {
    this(fluent, instance, false);
  }
  public InfrastructureListBuilder(io.fabric8.openshift.api.model.InfrastructureListFluent<?> fluent,io.fabric8.openshift.api.model.InfrastructureList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public InfrastructureListBuilder(io.fabric8.openshift.api.model.InfrastructureList instance) {
    this(instance,false);
  }
  public InfrastructureListBuilder(io.fabric8.openshift.api.model.InfrastructureList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.InfrastructureListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.InfrastructureList build() {
    InfrastructureList buildable = new InfrastructureList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}