package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageTagListBuilder extends ImageTagListFluentImpl<ImageTagListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageTagList,io.fabric8.openshift.api.model.ImageTagListBuilder>{
  public ImageTagListBuilder() {
    this(false);
  }
  public ImageTagListBuilder(Boolean validationEnabled) {
    this(new ImageTagList(), validationEnabled);
  }
  public ImageTagListBuilder(ImageTagListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageTagListBuilder(io.fabric8.openshift.api.model.ImageTagListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageTagList(), validationEnabled);
  }
  public ImageTagListBuilder(io.fabric8.openshift.api.model.ImageTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageTagList instance) {
    this(fluent, instance, false);
  }
  public ImageTagListBuilder(io.fabric8.openshift.api.model.ImageTagListFluent<?> fluent,io.fabric8.openshift.api.model.ImageTagList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageTagListBuilder(io.fabric8.openshift.api.model.ImageTagList instance) {
    this(instance,false);
  }
  public ImageTagListBuilder(io.fabric8.openshift.api.model.ImageTagList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageTagListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageTagList build() {
    ImageTagList buildable = new ImageTagList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}