package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageTagFluentImpl<A extends ImageTagFluent<A>> extends BaseFluent<A> implements ImageTagFluent<A>{
  public ImageTagFluentImpl() {
  }
  public ImageTagFluentImpl(ImageTag instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private ImageBuilder image;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private TagReferenceBuilder spec;
  private NamedTagEventListBuilder status;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildImage instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.openshift.api.model.Image getImage() {
    return this.image!=null ?this.image.build():null;
  }
  public io.fabric8.openshift.api.model.Image buildImage() {
    return this.image!=null ?this.image.build():null;
  }
  public A withImage(io.fabric8.openshift.api.model.Image image) {
    _visitables.get("image").remove(this.image);
    if (image!=null){ this.image= new io.fabric8.openshift.api.model.ImageBuilder(image); _visitables.get("image").add(this.image);} return (A) this;
  }
  public java.lang.Boolean hasImage() {
    return this.image != null;
  }
  public ImageTagFluent.ImageNested<A> withNewImage() {
    return new ImageTagFluentImpl.ImageNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.ImageNested<A> withNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return new ImageTagFluentImpl.ImageNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.ImageNested<A> editImage() {
    return withNewImageLike(getImage());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.ImageNested<A> editOrNewImage() {
    return withNewImageLike(getImage() != null ? getImage(): new io.fabric8.openshift.api.model.ImageBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.ImageNested<A> editOrNewImageLike(io.fabric8.openshift.api.model.Image item) {
    return withNewImageLike(getImage() != null ? getImage(): item);
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ImageTagFluent.MetadataNested<A> withNewMetadata() {
    return new ImageTagFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new io.fabric8.openshift.api.model.ImageTagFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TagReference getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public io.fabric8.openshift.api.model.TagReference buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(io.fabric8.openshift.api.model.TagReference spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new io.fabric8.openshift.api.model.TagReferenceBuilder(spec); _visitables.get("spec").add(this.spec);} return (A) this;
  }
  public java.lang.Boolean hasSpec() {
    return this.spec != null;
  }
  public ImageTagFluent.SpecNested<A> withNewSpec() {
    return new ImageTagFluentImpl.SpecNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.SpecNested<A> withNewSpecLike(io.fabric8.openshift.api.model.TagReference item) {
    return new io.fabric8.openshift.api.model.ImageTagFluentImpl.SpecNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new io.fabric8.openshift.api.model.TagReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.SpecNested<A> editOrNewSpecLike(io.fabric8.openshift.api.model.TagReference item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public NamedTagEventList getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public io.fabric8.openshift.api.model.NamedTagEventList buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(io.fabric8.openshift.api.model.NamedTagEventList status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new io.fabric8.openshift.api.model.NamedTagEventListBuilder(status); _visitables.get("status").add(this.status);} return (A) this;
  }
  public java.lang.Boolean hasStatus() {
    return this.status != null;
  }
  public ImageTagFluent.StatusNested<A> withNewStatus() {
    return new ImageTagFluentImpl.StatusNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.StatusNested<A> withNewStatusLike(io.fabric8.openshift.api.model.NamedTagEventList item) {
    return new io.fabric8.openshift.api.model.ImageTagFluentImpl.StatusNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new io.fabric8.openshift.api.model.NamedTagEventListBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageTagFluent.StatusNested<A> editOrNewStatusLike(io.fabric8.openshift.api.model.NamedTagEventList item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageTagFluentImpl that = (ImageTagFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (image != null ? !image.equals(that.image) :that.image != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  image,  kind,  metadata,  spec,  status,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ImageNestedImpl<N> extends ImageFluentImpl<ImageTagFluent.ImageNested<N>> implements ImageTagFluent.ImageNested<N>,Nested<N>{
    ImageNestedImpl(io.fabric8.openshift.api.model.Image item) {
      this.builder = new ImageBuilder(this, item);
    }
    ImageNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ImageBuilder(this);
    }
    io.fabric8.openshift.api.model.ImageBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withImage(builder.build());
    }
    public N endImage() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ImageTagFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.ImageTagFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends TagReferenceFluentImpl<ImageTagFluent.SpecNested<N>> implements io.fabric8.openshift.api.model.ImageTagFluent.SpecNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SpecNestedImpl(TagReference item) {
      this.builder = new TagReferenceBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TagReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.TagReferenceBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends NamedTagEventListFluentImpl<ImageTagFluent.StatusNested<N>> implements io.fabric8.openshift.api.model.ImageTagFluent.StatusNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    StatusNestedImpl(NamedTagEventList item) {
      this.builder = new NamedTagEventListBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.NamedTagEventListBuilder(this);
    }
    io.fabric8.openshift.api.model.NamedTagEventListBuilder builder;
    public N and() {
      return (N) ImageTagFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}