package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageTagBuilder extends ImageTagFluentImpl<ImageTagBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageTag,io.fabric8.openshift.api.model.ImageTagBuilder>{
  public ImageTagBuilder() {
    this(false);
  }
  public ImageTagBuilder(Boolean validationEnabled) {
    this(new ImageTag(), validationEnabled);
  }
  public ImageTagBuilder(ImageTagFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageTagBuilder(io.fabric8.openshift.api.model.ImageTagFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageTag(), validationEnabled);
  }
  public ImageTagBuilder(io.fabric8.openshift.api.model.ImageTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageTag instance) {
    this(fluent, instance, false);
  }
  public ImageTagBuilder(io.fabric8.openshift.api.model.ImageTagFluent<?> fluent,io.fabric8.openshift.api.model.ImageTag instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageTagBuilder(io.fabric8.openshift.api.model.ImageTag instance) {
    this(instance,false);
  }
  public ImageTagBuilder(io.fabric8.openshift.api.model.ImageTag instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageTagFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageTag build() {
    ImageTag buildable = new ImageTag(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}