package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamStatusBuilder extends ImageStreamStatusFluentImpl<ImageStreamStatusBuilder> implements VisitableBuilder<ImageStreamStatus,io.fabric8.openshift.api.model.ImageStreamStatusBuilder>{
  public ImageStreamStatusBuilder() {
    this(false);
  }
  public ImageStreamStatusBuilder(Boolean validationEnabled) {
    this(new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(ImageStreamStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamStatus(), validationEnabled);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDockerImageRepository(instance.getDockerImageRepository()); 
    fluent.withPublicDockerImageRepository(instance.getPublicDockerImageRepository()); 
    fluent.withTags(instance.getTags()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatus instance) {
    this(instance,false);
  }
  public ImageStreamStatusBuilder(io.fabric8.openshift.api.model.ImageStreamStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDockerImageRepository(instance.getDockerImageRepository()); 
    this.withPublicDockerImageRepository(instance.getPublicDockerImageRepository()); 
    this.withTags(instance.getTags()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamStatus build() {
    ImageStreamStatus buildable = new ImageStreamStatus(fluent.getDockerImageRepository(),fluent.getPublicDockerImageRepository(),fluent.getTags());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}