package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamMappingBuilder extends ImageStreamMappingFluentImpl<ImageStreamMappingBuilder> implements VisitableBuilder<ImageStreamMapping,io.fabric8.openshift.api.model.ImageStreamMappingBuilder>{
  public ImageStreamMappingBuilder() {
    this(false);
  }
  public ImageStreamMappingBuilder(Boolean validationEnabled) {
    this(new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(ImageStreamMappingFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamMapping(), validationEnabled);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamMapping instance) {
    this(fluent, instance, false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withImage(instance.getImage()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withTag(instance.getTag()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMapping instance) {
    this(instance,false);
  }
  public ImageStreamMappingBuilder(io.fabric8.openshift.api.model.ImageStreamMapping instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withImage(instance.getImage()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withTag(instance.getTag()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamMappingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamMapping build() {
    ImageStreamMapping buildable = new ImageStreamMapping(fluent.getApiVersion(),fluent.getImage(),fluent.getKind(),fluent.getMetadata(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}