package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamListBuilder extends ImageStreamListFluentImpl<ImageStreamListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamList,io.fabric8.openshift.api.model.ImageStreamListBuilder>{
  public ImageStreamListBuilder() {
    this(false);
  }
  public ImageStreamListBuilder(Boolean validationEnabled) {
    this(new ImageStreamList(), validationEnabled);
  }
  public ImageStreamListBuilder(ImageStreamListFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamListBuilder(io.fabric8.openshift.api.model.ImageStreamListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamList(), validationEnabled);
  }
  public ImageStreamListBuilder(io.fabric8.openshift.api.model.ImageStreamListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamList instance) {
    this(fluent, instance, false);
  }
  public ImageStreamListBuilder(io.fabric8.openshift.api.model.ImageStreamListFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamListBuilder(io.fabric8.openshift.api.model.ImageStreamList instance) {
    this(instance,false);
  }
  public ImageStreamListBuilder(io.fabric8.openshift.api.model.ImageStreamList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamList build() {
    ImageStreamList buildable = new ImageStreamList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}