package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImportStatusBuilder extends ImageStreamImportStatusFluentImpl<ImageStreamImportStatusBuilder> implements VisitableBuilder<ImageStreamImportStatus,io.fabric8.openshift.api.model.ImageStreamImportStatusBuilder>{
  public ImageStreamImportStatusBuilder() {
    this(false);
  }
  public ImageStreamImportStatusBuilder(Boolean validationEnabled) {
    this(new ImageStreamImportStatus(), validationEnabled);
  }
  public ImageStreamImportStatusBuilder(ImageStreamImportStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImportStatusBuilder(io.fabric8.openshift.api.model.ImageStreamImportStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamImportStatus(), validationEnabled);
  }
  public ImageStreamImportStatusBuilder(io.fabric8.openshift.api.model.ImageStreamImportStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImportStatus instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImportStatusBuilder(io.fabric8.openshift.api.model.ImageStreamImportStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImportStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImages(instance.getImages()); 
    fluent.withImport(instance.getImport()); 
    fluent.withRepository(instance.getRepository()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImportStatusBuilder(io.fabric8.openshift.api.model.ImageStreamImportStatus instance) {
    this(instance,false);
  }
  public ImageStreamImportStatusBuilder(io.fabric8.openshift.api.model.ImageStreamImportStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImages(instance.getImages()); 
    this.withImport(instance.getImport()); 
    this.withRepository(instance.getRepository()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamImportStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamImportStatus build() {
    ImageStreamImportStatus buildable = new ImageStreamImportStatus(fluent.getImages(),fluent.getImport(),fluent.getRepository());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}