package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageStreamImportBuilder extends ImageStreamImportFluentImpl<ImageStreamImportBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ImageStreamImport,ImageStreamImportBuilder>{
  public ImageStreamImportBuilder() {
    this(false);
  }
  public ImageStreamImportBuilder(Boolean validationEnabled) {
    this(new ImageStreamImport(), validationEnabled);
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImportFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImportFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageStreamImport(), validationEnabled);
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImportFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImport instance) {
    this(fluent, instance, false);
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImportFluent<?> fluent,io.fabric8.openshift.api.model.ImageStreamImport instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImport instance) {
    this(instance,false);
  }
  public ImageStreamImportBuilder(io.fabric8.openshift.api.model.ImageStreamImport instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageStreamImportFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageStreamImport build() {
    ImageStreamImport buildable = new ImageStreamImport(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}