package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageImportStatusBuilder extends ImageImportStatusFluentImpl<ImageImportStatusBuilder> implements VisitableBuilder<ImageImportStatus,io.fabric8.openshift.api.model.ImageImportStatusBuilder>{
  public ImageImportStatusBuilder() {
    this(false);
  }
  public ImageImportStatusBuilder(Boolean validationEnabled) {
    this(new ImageImportStatus(), validationEnabled);
  }
  public ImageImportStatusBuilder(ImageImportStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageImportStatusBuilder(io.fabric8.openshift.api.model.ImageImportStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ImageImportStatus(), validationEnabled);
  }
  public ImageImportStatusBuilder(io.fabric8.openshift.api.model.ImageImportStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageImportStatus instance) {
    this(fluent, instance, false);
  }
  public ImageImportStatusBuilder(io.fabric8.openshift.api.model.ImageImportStatusFluent<?> fluent,io.fabric8.openshift.api.model.ImageImportStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImage(instance.getImage()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withTag(instance.getTag()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageImportStatusBuilder(io.fabric8.openshift.api.model.ImageImportStatus instance) {
    this(instance,false);
  }
  public ImageImportStatusBuilder(io.fabric8.openshift.api.model.ImageImportStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImage(instance.getImage()); 
    this.withStatus(instance.getStatus()); 
    this.withTag(instance.getTag()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageImportStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ImageImportStatus build() {
    ImageImportStatus buildable = new ImageImportStatus(fluent.getImage(),fluent.getStatus(),fluent.getTag());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}