package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ImageImportSpecFluentImpl<A extends ImageImportSpecFluent<A>> extends BaseFluent<A> implements ImageImportSpecFluent<A>{
  public ImageImportSpecFluentImpl() {
  }
  public ImageImportSpecFluentImpl(io.fabric8.openshift.api.model.ImageImportSpec instance) {
    this.withFrom(instance.getFrom()); 
    this.withImportPolicy(instance.getImportPolicy()); 
    this.withIncludeManifest(instance.getIncludeManifest()); 
    this.withReferencePolicy(instance.getReferencePolicy()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ObjectReferenceBuilder from;
  private TagImportPolicyBuilder importPolicy;
  private Boolean includeManifest;
  private TagReferencePolicyBuilder referencePolicy;
  private LocalObjectReferenceBuilder to;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
  }
  public java.lang.Boolean hasFrom() {
    return this.from != null;
  }
  public ImageImportSpecFluent.FromNested<A> withNewFrom() {
    return new ImageImportSpecFluentImpl.FromNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new ImageImportSpecFluentImpl.FromNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildImportPolicy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.openshift.api.model.TagImportPolicy getImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public io.fabric8.openshift.api.model.TagImportPolicy buildImportPolicy() {
    return this.importPolicy!=null ?this.importPolicy.build():null;
  }
  public A withImportPolicy(io.fabric8.openshift.api.model.TagImportPolicy importPolicy) {
    _visitables.get("importPolicy").remove(this.importPolicy);
    if (importPolicy!=null){ this.importPolicy= new TagImportPolicyBuilder(importPolicy); _visitables.get("importPolicy").add(this.importPolicy);} return (A) this;
  }
  public java.lang.Boolean hasImportPolicy() {
    return this.importPolicy != null;
  }
  public A withNewImportPolicy(java.lang.Boolean insecure,java.lang.Boolean scheduled) {
    return (A)withImportPolicy(new TagImportPolicy(insecure, scheduled));
  }
  public ImageImportSpecFluent.ImportPolicyNested<A> withNewImportPolicy() {
    return new ImageImportSpecFluentImpl.ImportPolicyNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> withNewImportPolicyLike(io.fabric8.openshift.api.model.TagImportPolicy item) {
    return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ImportPolicyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editOrNewImportPolicy() {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): new io.fabric8.openshift.api.model.TagImportPolicyBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<A> editOrNewImportPolicyLike(io.fabric8.openshift.api.model.TagImportPolicy item) {
    return withNewImportPolicyLike(getImportPolicy() != null ? getImportPolicy(): item);
  }
  public java.lang.Boolean getIncludeManifest() {
    return this.includeManifest;
  }
  public A withIncludeManifest(java.lang.Boolean includeManifest) {
    this.includeManifest=includeManifest; return (A) this;
  }
  public java.lang.Boolean hasIncludeManifest() {
    return this.includeManifest != null;
  }
  
  /**
   * This method has been deprecated, please use method buildReferencePolicy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public TagReferencePolicy getReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public io.fabric8.openshift.api.model.TagReferencePolicy buildReferencePolicy() {
    return this.referencePolicy!=null ?this.referencePolicy.build():null;
  }
  public A withReferencePolicy(io.fabric8.openshift.api.model.TagReferencePolicy referencePolicy) {
    _visitables.get("referencePolicy").remove(this.referencePolicy);
    if (referencePolicy!=null){ this.referencePolicy= new io.fabric8.openshift.api.model.TagReferencePolicyBuilder(referencePolicy); _visitables.get("referencePolicy").add(this.referencePolicy);} return (A) this;
  }
  public java.lang.Boolean hasReferencePolicy() {
    return this.referencePolicy != null;
  }
  public A withNewReferencePolicy(java.lang.String type) {
    return (A)withReferencePolicy(new TagReferencePolicy(type));
  }
  public ImageImportSpecFluent.ReferencePolicyNested<A> withNewReferencePolicy() {
    return new ImageImportSpecFluentImpl.ReferencePolicyNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> withNewReferencePolicyLike(io.fabric8.openshift.api.model.TagReferencePolicy item) {
    return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ReferencePolicyNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editOrNewReferencePolicy() {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): new io.fabric8.openshift.api.model.TagReferencePolicyBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<A> editOrNewReferencePolicyLike(io.fabric8.openshift.api.model.TagReferencePolicy item) {
    return withNewReferencePolicyLike(getReferencePolicy() != null ? getReferencePolicy(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalObjectReference getTo() {
    return this.to!=null ?this.to.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildTo() {
    return this.to!=null ?this.to.build():null;
  }
  public A withTo(io.fabric8.kubernetes.api.model.LocalObjectReference to) {
    _visitables.get("to").remove(this.to);
    if (to!=null){ this.to= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(to); _visitables.get("to").add(this.to);} return (A) this;
  }
  public java.lang.Boolean hasTo() {
    return this.to != null;
  }
  public A withNewTo(java.lang.String name) {
    return (A)withTo(new LocalObjectReference(name));
  }
  public ImageImportSpecFluent.ToNested<A> withNewTo() {
    return new ImageImportSpecFluentImpl.ToNestedImpl();
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> withNewToLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.ImageImportSpecFluentImpl.ToNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editTo() {
    return withNewToLike(getTo());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editOrNewTo() {
    return withNewToLike(getTo() != null ? getTo(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<A> editOrNewToLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewToLike(getTo() != null ? getTo(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ImageImportSpecFluentImpl that = (ImageImportSpecFluentImpl) o;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (importPolicy != null ? !importPolicy.equals(that.importPolicy) :that.importPolicy != null) return false;
    if (includeManifest != null ? !includeManifest.equals(that.includeManifest) :that.includeManifest != null) return false;
    if (referencePolicy != null ? !referencePolicy.equals(that.referencePolicy) :that.referencePolicy != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(from,  importPolicy,  includeManifest,  referencePolicy,  to,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (importPolicy != null) { sb.append("importPolicy:"); sb.append(importPolicy + ","); }
    if (includeManifest != null) { sb.append("includeManifest:"); sb.append(includeManifest + ","); }
    if (referencePolicy != null) { sb.append("referencePolicy:"); sb.append(referencePolicy + ","); }
    if (to != null) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withIncludeManifest() {
    return withIncludeManifest(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<ImageImportSpecFluent.FromNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.FromNested<N>,Nested<N>{
    FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class ImportPolicyNestedImpl<N> extends TagImportPolicyFluentImpl<ImageImportSpecFluent.ImportPolicyNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ImportPolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ImportPolicyNestedImpl(io.fabric8.openshift.api.model.TagImportPolicy item) {
      this.builder = new TagImportPolicyBuilder(this, item);
    }
    ImportPolicyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TagImportPolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.TagImportPolicyBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withImportPolicy(builder.build());
    }
    public N endImportPolicy() {
      return and();
    }
    
  }
  class ReferencePolicyNestedImpl<N> extends TagReferencePolicyFluentImpl<ImageImportSpecFluent.ReferencePolicyNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ReferencePolicyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ReferencePolicyNestedImpl(io.fabric8.openshift.api.model.TagReferencePolicy item) {
      this.builder = new TagReferencePolicyBuilder(this, item);
    }
    ReferencePolicyNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.TagReferencePolicyBuilder(this);
    }
    io.fabric8.openshift.api.model.TagReferencePolicyBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withReferencePolicy(builder.build());
    }
    public N endReferencePolicy() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends LocalObjectReferenceFluentImpl<ImageImportSpecFluent.ToNested<N>> implements io.fabric8.openshift.api.model.ImageImportSpecFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ToNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    ToNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) ImageImportSpecFluentImpl.this.withTo(builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}