package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.openshift.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.openshift.api.model.runtime.RawExtension;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public interface ImageFluent<A extends ImageFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(java.lang.String apiVersion);
  public Boolean hasApiVersion();
  public java.lang.String getDockerImageConfig();
  public A withDockerImageConfig(java.lang.String dockerImageConfig);
  public java.lang.Boolean hasDockerImageConfig();
  public A addToDockerImageLayers(Integer index,ImageLayer item);
  public A setToDockerImageLayers(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item);
  public A addToDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items);
  public A addAllToDockerImageLayers(Collection<io.fabric8.openshift.api.model.ImageLayer> items);
  public A removeFromDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... items);
  public A removeAllFromDockerImageLayers(java.util.Collection<io.fabric8.openshift.api.model.ImageLayer> items);
  public A removeMatchingFromDockerImageLayers(Predicate<ImageLayerBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildDockerImageLayers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.openshift.api.model.ImageLayer> getDockerImageLayers();
  public java.util.List<io.fabric8.openshift.api.model.ImageLayer> buildDockerImageLayers();
  public io.fabric8.openshift.api.model.ImageLayer buildDockerImageLayer(java.lang.Integer index);
  public io.fabric8.openshift.api.model.ImageLayer buildFirstDockerImageLayer();
  public io.fabric8.openshift.api.model.ImageLayer buildLastDockerImageLayer();
  public io.fabric8.openshift.api.model.ImageLayer buildMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate);
  public java.lang.Boolean hasMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate);
  public A withDockerImageLayers(java.util.List<io.fabric8.openshift.api.model.ImageLayer> dockerImageLayers);
  public A withDockerImageLayers(io.fabric8.openshift.api.model.ImageLayer... dockerImageLayers);
  public java.lang.Boolean hasDockerImageLayers();
  public A addNewDockerImageLayer(java.lang.String mediaType,java.lang.String name,Long size);
  public ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayer();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> addNewDockerImageLayerLike(io.fabric8.openshift.api.model.ImageLayer item);
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> setNewDockerImageLayerLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageLayer item);
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editDockerImageLayer(java.lang.Integer index);
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editFirstDockerImageLayer();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editLastDockerImageLayer();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageLayersNested<A> editMatchingDockerImageLayer(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageLayerBuilder> predicate);
  public java.lang.String getDockerImageManifest();
  public A withDockerImageManifest(java.lang.String dockerImageManifest);
  public java.lang.Boolean hasDockerImageManifest();
  public java.lang.String getDockerImageManifestMediaType();
  public A withDockerImageManifestMediaType(java.lang.String dockerImageManifestMediaType);
  public java.lang.Boolean hasDockerImageManifestMediaType();
  
  /**
   * This method has been deprecated, please use method buildDockerImageMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public RawExtension getDockerImageMetadata();
  public io.fabric8.openshift.api.model.runtime.RawExtension buildDockerImageMetadata();
  public A withDockerImageMetadata(io.fabric8.openshift.api.model.runtime.RawExtension dockerImageMetadata);
  public java.lang.Boolean hasDockerImageMetadata();
  public ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> withNewDockerImageMetadataLike(io.fabric8.openshift.api.model.runtime.RawExtension item);
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editDockerImageMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.DockerImageMetadataNested<A> editOrNewDockerImageMetadataLike(io.fabric8.openshift.api.model.runtime.RawExtension item);
  public java.lang.String getDockerImageMetadataVersion();
  public A withDockerImageMetadataVersion(java.lang.String dockerImageMetadataVersion);
  public java.lang.Boolean hasDockerImageMetadataVersion();
  public java.lang.String getDockerImageReference();
  public A withDockerImageReference(java.lang.String dockerImageReference);
  public java.lang.Boolean hasDockerImageReference();
  public A addToDockerImageSignatures(java.lang.Integer index,java.lang.String item);
  public A setToDockerImageSignatures(java.lang.Integer index,java.lang.String item);
  public A addToDockerImageSignatures(java.lang.String... items);
  public A addAllToDockerImageSignatures(java.util.Collection<java.lang.String> items);
  public A removeFromDockerImageSignatures(java.lang.String... items);
  public A removeAllFromDockerImageSignatures(java.util.Collection<java.lang.String> items);
  public java.util.List<java.lang.String> getDockerImageSignatures();
  public java.lang.String getDockerImageSignature(java.lang.Integer index);
  public java.lang.String getFirstDockerImageSignature();
  public java.lang.String getLastDockerImageSignature();
  public java.lang.String getMatchingDockerImageSignature(java.util.function.Predicate<java.lang.String> predicate);
  public java.lang.Boolean hasMatchingDockerImageSignature(java.util.function.Predicate<java.lang.String> predicate);
  public A withDockerImageSignatures(java.util.List<java.lang.String> dockerImageSignatures);
  public A withDockerImageSignatures(java.lang.String... dockerImageSignatures);
  public java.lang.Boolean hasDockerImageSignatures();
  public java.lang.String getKind();
  public A withKind(java.lang.String kind);
  public java.lang.Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public ObjectMeta getMetadata();
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata();
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata);
  public java.lang.Boolean hasMetadata();
  public ImageFluent.MetadataNested<A> withNewMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editOrNewMetadata();
  public io.fabric8.openshift.api.model.ImageFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item);
  public A addToSignatures(java.lang.Integer index,ImageSignature item);
  public A setToSignatures(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item);
  public A addToSignatures(io.fabric8.openshift.api.model.ImageSignature... items);
  public A addAllToSignatures(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items);
  public A removeFromSignatures(io.fabric8.openshift.api.model.ImageSignature... items);
  public A removeAllFromSignatures(java.util.Collection<io.fabric8.openshift.api.model.ImageSignature> items);
  public A removeMatchingFromSignatures(java.util.function.Predicate<ImageSignatureBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildSignatures instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.ImageSignature> getSignatures();
  public java.util.List<io.fabric8.openshift.api.model.ImageSignature> buildSignatures();
  public io.fabric8.openshift.api.model.ImageSignature buildSignature(java.lang.Integer index);
  public io.fabric8.openshift.api.model.ImageSignature buildFirstSignature();
  public io.fabric8.openshift.api.model.ImageSignature buildLastSignature();
  public io.fabric8.openshift.api.model.ImageSignature buildMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate);
  public java.lang.Boolean hasMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate);
  public A withSignatures(java.util.List<io.fabric8.openshift.api.model.ImageSignature> signatures);
  public A withSignatures(io.fabric8.openshift.api.model.ImageSignature... signatures);
  public java.lang.Boolean hasSignatures();
  public ImageFluent.SignaturesNested<A> addNewSignature();
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> addNewSignatureLike(io.fabric8.openshift.api.model.ImageSignature item);
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> setNewSignatureLike(java.lang.Integer index,io.fabric8.openshift.api.model.ImageSignature item);
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editSignature(java.lang.Integer index);
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editFirstSignature();
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editLastSignature();
  public io.fabric8.openshift.api.model.ImageFluent.SignaturesNested<A> editMatchingSignature(java.util.function.Predicate<io.fabric8.openshift.api.model.ImageSignatureBuilder> predicate);
  public A addToAdditionalProperties(java.lang.String key,Object value);
  public A addToAdditionalProperties(Map<java.lang.String,java.lang.Object> map);
  public A removeFromAdditionalProperties(java.lang.String key);
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map);
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties);
  public java.lang.Boolean hasAdditionalProperties();
  public interface DockerImageLayersNested<N> extends Nested<N>,ImageLayerFluent<ImageFluent.DockerImageLayersNested<N>>{
    public N and();
    public N endDockerImageLayer();
    
  }
  public interface DockerImageMetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RawExtensionFluent<ImageFluent.DockerImageMetadataNested<N>>{
    public N and();
    public N endDockerImageMetadata();
    
  }
  public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ImageFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SignaturesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ImageSignatureFluent<ImageFluent.SignaturesNested<N>>{
    public N and();
    public N endSignature();
    
  }
  
}