package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ImageBuilder extends ImageFluentImpl<ImageBuilder> implements VisitableBuilder<Image,io.fabric8.openshift.api.model.ImageBuilder>{
  public ImageBuilder() {
    this(false);
  }
  public ImageBuilder(Boolean validationEnabled) {
    this(new Image(), validationEnabled);
  }
  public ImageBuilder(ImageFluent<?> fluent) {
    this(fluent, false);
  }
  public ImageBuilder(io.fabric8.openshift.api.model.ImageFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Image(), validationEnabled);
  }
  public ImageBuilder(io.fabric8.openshift.api.model.ImageFluent<?> fluent,io.fabric8.openshift.api.model.Image instance) {
    this(fluent, instance, false);
  }
  public ImageBuilder(io.fabric8.openshift.api.model.ImageFluent<?> fluent,io.fabric8.openshift.api.model.Image instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDockerImageConfig(instance.getDockerImageConfig()); 
    fluent.withDockerImageLayers(instance.getDockerImageLayers()); 
    fluent.withDockerImageManifest(instance.getDockerImageManifest()); 
    fluent.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType()); 
    fluent.withDockerImageMetadata(instance.getDockerImageMetadata()); 
    fluent.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); 
    fluent.withDockerImageReference(instance.getDockerImageReference()); 
    fluent.withDockerImageSignatures(instance.getDockerImageSignatures()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSignatures(instance.getSignatures()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ImageBuilder(io.fabric8.openshift.api.model.Image instance) {
    this(instance,false);
  }
  public ImageBuilder(io.fabric8.openshift.api.model.Image instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDockerImageConfig(instance.getDockerImageConfig()); 
    this.withDockerImageLayers(instance.getDockerImageLayers()); 
    this.withDockerImageManifest(instance.getDockerImageManifest()); 
    this.withDockerImageManifestMediaType(instance.getDockerImageManifestMediaType()); 
    this.withDockerImageMetadata(instance.getDockerImageMetadata()); 
    this.withDockerImageMetadataVersion(instance.getDockerImageMetadataVersion()); 
    this.withDockerImageReference(instance.getDockerImageReference()); 
    this.withDockerImageSignatures(instance.getDockerImageSignatures()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSignatures(instance.getSignatures()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ImageFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Image build() {
    Image buildable = new Image(fluent.getApiVersion(),fluent.getDockerImageConfig(),fluent.getDockerImageLayers(),fluent.getDockerImageManifest(),fluent.getDockerImageManifestMediaType(),fluent.getDockerImageMetadata(),fluent.getDockerImageMetadataVersion(),fluent.getDockerImageReference(),fluent.getDockerImageSignatures(),fluent.getKind(),fluent.getMetadata(),fluent.getSignatures());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}