package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IDRangeBuilder extends IDRangeFluentImpl<IDRangeBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.IDRange,IDRangeBuilder>{
  public IDRangeBuilder() {
    this(false);
  }
  public IDRangeBuilder(Boolean validationEnabled) {
    this(new IDRange(), validationEnabled);
  }
  public IDRangeBuilder(IDRangeFluent<?> fluent) {
    this(fluent, false);
  }
  public IDRangeBuilder(io.fabric8.openshift.api.model.IDRangeFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IDRange(), validationEnabled);
  }
  public IDRangeBuilder(io.fabric8.openshift.api.model.IDRangeFluent<?> fluent,io.fabric8.openshift.api.model.IDRange instance) {
    this(fluent, instance, false);
  }
  public IDRangeBuilder(io.fabric8.openshift.api.model.IDRangeFluent<?> fluent,io.fabric8.openshift.api.model.IDRange instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMax(instance.getMax()); 
    fluent.withMin(instance.getMin()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IDRangeBuilder(io.fabric8.openshift.api.model.IDRange instance) {
    this(instance,false);
  }
  public IDRangeBuilder(io.fabric8.openshift.api.model.IDRange instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMax(instance.getMax()); 
    this.withMin(instance.getMin()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IDRangeFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IDRange build() {
    IDRange buildable = new IDRange(fluent.getMax(),fluent.getMin());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}