package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IBMCloudPlatformStatusBuilder extends IBMCloudPlatformStatusFluentImpl<IBMCloudPlatformStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.IBMCloudPlatformStatus,io.fabric8.openshift.api.model.IBMCloudPlatformStatusBuilder>{
  public IBMCloudPlatformStatusBuilder() {
    this(false);
  }
  public IBMCloudPlatformStatusBuilder(Boolean validationEnabled) {
    this(new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(IBMCloudPlatformStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IBMCloudPlatformStatus(), validationEnabled);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance) {
    this(fluent, instance, false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent,io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    fluent.withLocation(instance.getLocation()); 
    fluent.withProviderType(instance.getProviderType()); 
    fluent.withResourceGroupName(instance.getResourceGroupName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance) {
    this(instance,false);
  }
  public IBMCloudPlatformStatusBuilder(io.fabric8.openshift.api.model.IBMCloudPlatformStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCisInstanceCRN(instance.getCisInstanceCRN()); 
    this.withLocation(instance.getLocation()); 
    this.withProviderType(instance.getProviderType()); 
    this.withResourceGroupName(instance.getResourceGroupName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.IBMCloudPlatformStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.IBMCloudPlatformStatus build() {
    IBMCloudPlatformStatus buildable = new IBMCloudPlatformStatus(fluent.getCisInstanceCRN(),fluent.getLocation(),fluent.getProviderType(),fluent.getResourceGroupName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}