package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HubSourceStatusBuilder extends HubSourceStatusFluentImpl<HubSourceStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.HubSourceStatus,io.fabric8.openshift.api.model.HubSourceStatusBuilder>{
  public HubSourceStatusBuilder() {
    this(false);
  }
  public HubSourceStatusBuilder(Boolean validationEnabled) {
    this(new HubSourceStatus(), validationEnabled);
  }
  public HubSourceStatusBuilder(HubSourceStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HubSourceStatusBuilder(io.fabric8.openshift.api.model.HubSourceStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HubSourceStatus(), validationEnabled);
  }
  public HubSourceStatusBuilder(io.fabric8.openshift.api.model.HubSourceStatusFluent<?> fluent,io.fabric8.openshift.api.model.HubSourceStatus instance) {
    this(fluent, instance, false);
  }
  public HubSourceStatusBuilder(io.fabric8.openshift.api.model.HubSourceStatusFluent<?> fluent,io.fabric8.openshift.api.model.HubSourceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withName(instance.getName()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HubSourceStatusBuilder(io.fabric8.openshift.api.model.HubSourceStatus instance) {
    this(instance,false);
  }
  public HubSourceStatusBuilder(io.fabric8.openshift.api.model.HubSourceStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withMessage(instance.getMessage()); 
    this.withName(instance.getName()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HubSourceStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HubSourceStatus build() {
    HubSourceStatus buildable = new HubSourceStatus(fluent.getDisabled(),fluent.getMessage(),fluent.getName(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}