package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HubSourceBuilder extends HubSourceFluentImpl<HubSourceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.HubSource,io.fabric8.openshift.api.model.HubSourceBuilder>{
  public HubSourceBuilder() {
    this(false);
  }
  public HubSourceBuilder(Boolean validationEnabled) {
    this(new HubSource(), validationEnabled);
  }
  public HubSourceBuilder(HubSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public HubSourceBuilder(io.fabric8.openshift.api.model.HubSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HubSource(), validationEnabled);
  }
  public HubSourceBuilder(io.fabric8.openshift.api.model.HubSourceFluent<?> fluent,io.fabric8.openshift.api.model.HubSource instance) {
    this(fluent, instance, false);
  }
  public HubSourceBuilder(io.fabric8.openshift.api.model.HubSourceFluent<?> fluent,io.fabric8.openshift.api.model.HubSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withName(instance.getName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HubSourceBuilder(io.fabric8.openshift.api.model.HubSource instance) {
    this(instance,false);
  }
  public HubSourceBuilder(io.fabric8.openshift.api.model.HubSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withName(instance.getName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HubSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HubSource build() {
    HubSource buildable = new HubSource(fluent.getDisabled(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}