package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HostSubnetFluentImpl<A extends HostSubnetFluent<A>> extends BaseFluent<A> implements HostSubnetFluent<A>{
  public HostSubnetFluentImpl() {
  }
  public HostSubnetFluentImpl(io.fabric8.openshift.api.model.HostSubnet instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withEgressCIDRs(instance.getEgressCIDRs()); 
    this.withEgressIPs(instance.getEgressIPs()); 
    this.withHost(instance.getHost()); 
    this.withHostIP(instance.getHostIP()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubnet(instance.getSubnet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private List<java.lang.String> egressCIDRs = new ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> egressIPs = new java.util.ArrayList<java.lang.String>();
  private java.lang.String host;
  private java.lang.String hostIP;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private java.lang.String subnet;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public A addToEgressCIDRs(Integer index,java.lang.String item) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new java.util.ArrayList<java.lang.String>();}
    this.egressCIDRs.add(index, item);
    return (A)this;
  }
  public A setToEgressCIDRs(java.lang.Integer index,java.lang.String item) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new java.util.ArrayList<java.lang.String>();}
    this.egressCIDRs.set(index, item); return (A)this;
  }
  public A addToEgressCIDRs(java.lang.String... items) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressCIDRs.add(item);} return (A)this;
  }
  public A addAllToEgressCIDRs(Collection<java.lang.String> items) {
    if (this.egressCIDRs == null) {this.egressCIDRs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressCIDRs.add(item);} return (A)this;
  }
  public A removeFromEgressCIDRs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.egressCIDRs!= null){ this.egressCIDRs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressCIDRs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.egressCIDRs!= null){ this.egressCIDRs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getEgressCIDRs() {
    return this.egressCIDRs;
  }
  public java.lang.String getEgressCIDR(java.lang.Integer index) {
    return this.egressCIDRs.get(index);
  }
  public java.lang.String getFirstEgressCIDR() {
    return this.egressCIDRs.get(0);
  }
  public java.lang.String getLastEgressCIDR() {
    return this.egressCIDRs.get(egressCIDRs.size() - 1);
  }
  public java.lang.String getMatchingEgressCIDR(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressCIDRs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEgressCIDR(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressCIDRs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressCIDRs(java.util.List<java.lang.String> egressCIDRs) {
    if (egressCIDRs != null) {this.egressCIDRs = new java.util.ArrayList(); for (java.lang.String item : egressCIDRs){this.addToEgressCIDRs(item);}} else { this.egressCIDRs = null;} return (A) this;
  }
  public A withEgressCIDRs(java.lang.String... egressCIDRs) {
    if (this.egressCIDRs != null) {this.egressCIDRs.clear();}
    if (egressCIDRs != null) {for (java.lang.String item :egressCIDRs){ this.addToEgressCIDRs(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgressCIDRs() {
    return egressCIDRs != null && !egressCIDRs.isEmpty();
  }
  public A addToEgressIPs(java.lang.Integer index,java.lang.String item) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    this.egressIPs.add(index, item);
    return (A)this;
  }
  public A setToEgressIPs(java.lang.Integer index,java.lang.String item) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    this.egressIPs.set(index, item); return (A)this;
  }
  public A addToEgressIPs(java.lang.String... items) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A addAllToEgressIPs(java.util.Collection<java.lang.String> items) {
    if (this.egressIPs == null) {this.egressIPs = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.egressIPs.add(item);} return (A)this;
  }
  public A removeFromEgressIPs(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public A removeAllFromEgressIPs(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.egressIPs!= null){ this.egressIPs.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getEgressIPs() {
    return this.egressIPs;
  }
  public java.lang.String getEgressIP(java.lang.Integer index) {
    return this.egressIPs.get(index);
  }
  public java.lang.String getFirstEgressIP() {
    return this.egressIPs.get(0);
  }
  public java.lang.String getLastEgressIP() {
    return this.egressIPs.get(egressIPs.size() - 1);
  }
  public java.lang.String getMatchingEgressIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEgressIP(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: egressIPs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEgressIPs(java.util.List<java.lang.String> egressIPs) {
    if (egressIPs != null) {this.egressIPs = new java.util.ArrayList(); for (java.lang.String item : egressIPs){this.addToEgressIPs(item);}} else { this.egressIPs = null;} return (A) this;
  }
  public A withEgressIPs(java.lang.String... egressIPs) {
    if (this.egressIPs != null) {this.egressIPs.clear();}
    if (egressIPs != null) {for (java.lang.String item :egressIPs){ this.addToEgressIPs(item);}} return (A) this;
  }
  public java.lang.Boolean hasEgressIPs() {
    return egressIPs != null && !egressIPs.isEmpty();
  }
  public java.lang.String getHost() {
    return this.host;
  }
  public A withHost(java.lang.String host) {
    this.host=host; return (A) this;
  }
  public java.lang.Boolean hasHost() {
    return this.host != null;
  }
  public java.lang.String getHostIP() {
    return this.hostIP;
  }
  public A withHostIP(java.lang.String hostIP) {
    this.hostIP=hostIP; return (A) this;
  }
  public java.lang.Boolean hasHostIP() {
    return this.hostIP != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public HostSubnetFluent.MetadataNested<A> withNewMetadata() {
    return new HostSubnetFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.HostSubnetFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new HostSubnetFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.HostSubnetFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.HostSubnetFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.HostSubnetFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public java.lang.String getSubnet() {
    return this.subnet;
  }
  public A withSubnet(java.lang.String subnet) {
    this.subnet=subnet; return (A) this;
  }
  public java.lang.Boolean hasSubnet() {
    return this.subnet != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HostSubnetFluentImpl that = (HostSubnetFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (egressCIDRs != null ? !egressCIDRs.equals(that.egressCIDRs) :that.egressCIDRs != null) return false;
    if (egressIPs != null ? !egressIPs.equals(that.egressIPs) :that.egressIPs != null) return false;
    if (host != null ? !host.equals(that.host) :that.host != null) return false;
    if (hostIP != null ? !hostIP.equals(that.hostIP) :that.hostIP != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (subnet != null ? !subnet.equals(that.subnet) :that.subnet != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  egressCIDRs,  egressIPs,  host,  hostIP,  kind,  metadata,  subnet,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (egressCIDRs != null && !egressCIDRs.isEmpty()) { sb.append("egressCIDRs:"); sb.append(egressCIDRs + ","); }
    if (egressIPs != null && !egressIPs.isEmpty()) { sb.append("egressIPs:"); sb.append(egressIPs + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (hostIP != null) { sb.append("hostIP:"); sb.append(hostIP + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (subnet != null) { sb.append("subnet:"); sb.append(subnet + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<HostSubnetFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.HostSubnetFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) HostSubnetFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}