package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HostSubnetBuilder extends HostSubnetFluentImpl<HostSubnetBuilder> implements VisitableBuilder<HostSubnet,io.fabric8.openshift.api.model.HostSubnetBuilder>{
  public HostSubnetBuilder() {
    this(false);
  }
  public HostSubnetBuilder(Boolean validationEnabled) {
    this(new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(HostSubnetFluent<?> fluent) {
    this(fluent, false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HostSubnet(), validationEnabled);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnet instance) {
    this(fluent, instance, false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent,io.fabric8.openshift.api.model.HostSubnet instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withEgressCIDRs(instance.getEgressCIDRs()); 
    fluent.withEgressIPs(instance.getEgressIPs()); 
    fluent.withHost(instance.getHost()); 
    fluent.withHostIP(instance.getHostIP()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSubnet(instance.getSubnet()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnet instance) {
    this(instance,false);
  }
  public HostSubnetBuilder(io.fabric8.openshift.api.model.HostSubnet instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withEgressCIDRs(instance.getEgressCIDRs()); 
    this.withEgressIPs(instance.getEgressIPs()); 
    this.withHost(instance.getHost()); 
    this.withHostIP(instance.getHostIP()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSubnet(instance.getSubnet()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HostSubnetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HostSubnet build() {
    HostSubnet buildable = new HostSubnet(fluent.getApiVersion(),fluent.getEgressCIDRs(),fluent.getEgressIPs(),fluent.getHost(),fluent.getHostIP(),fluent.getKind(),fluent.getMetadata(),fluent.getSubnet());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}