package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HelmChartRepositoryListBuilder extends HelmChartRepositoryListFluentImpl<HelmChartRepositoryListBuilder> implements VisitableBuilder<HelmChartRepositoryList,io.fabric8.openshift.api.model.HelmChartRepositoryListBuilder>{
  public HelmChartRepositoryListBuilder() {
    this(false);
  }
  public HelmChartRepositoryListBuilder(Boolean validationEnabled) {
    this(new HelmChartRepositoryList(), validationEnabled);
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryListFluent<?> fluent) {
    this(fluent, false);
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new HelmChartRepositoryList(), validationEnabled);
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryListFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepositoryList instance) {
    this(fluent, instance, false);
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryListFluent<?> fluent,io.fabric8.openshift.api.model.HelmChartRepositoryList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryList instance) {
    this(instance,false);
  }
  public HelmChartRepositoryListBuilder(io.fabric8.openshift.api.model.HelmChartRepositoryList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.HelmChartRepositoryListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.HelmChartRepositoryList build() {
    HelmChartRepositoryList buildable = new HelmChartRepositoryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}