package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GroupRestrictionBuilder extends GroupRestrictionFluentImpl<GroupRestrictionBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.GroupRestriction,io.fabric8.openshift.api.model.GroupRestrictionBuilder>{
  public GroupRestrictionBuilder() {
    this(false);
  }
  public GroupRestrictionBuilder(Boolean validationEnabled) {
    this(new GroupRestriction(), validationEnabled);
  }
  public GroupRestrictionBuilder(GroupRestrictionFluent<?> fluent) {
    this(fluent, false);
  }
  public GroupRestrictionBuilder(io.fabric8.openshift.api.model.GroupRestrictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GroupRestriction(), validationEnabled);
  }
  public GroupRestrictionBuilder(io.fabric8.openshift.api.model.GroupRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.GroupRestriction instance) {
    this(fluent, instance, false);
  }
  public GroupRestrictionBuilder(io.fabric8.openshift.api.model.GroupRestrictionFluent<?> fluent,io.fabric8.openshift.api.model.GroupRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withGroups(instance.getGroups()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GroupRestrictionBuilder(io.fabric8.openshift.api.model.GroupRestriction instance) {
    this(instance,false);
  }
  public GroupRestrictionBuilder(io.fabric8.openshift.api.model.GroupRestriction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withGroups(instance.getGroups()); 
    this.withLabels(instance.getLabels()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GroupRestrictionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GroupRestriction build() {
    GroupRestriction buildable = new GroupRestriction(fluent.getGroups(),fluent.getLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}