package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GroupFluentImpl<A extends GroupFluent<A>> extends BaseFluent<A> implements GroupFluent<A>{
  public GroupFluentImpl() {
  }
  public GroupFluentImpl(io.fabric8.openshift.api.model.Group instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withUsers(instance.getUsers()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private java.lang.String kind;
  private ObjectMetaBuilder metadata;
  private List<java.lang.String> users = new ArrayList<java.lang.String>();
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(java.lang.String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public java.lang.String getKind() {
    return this.kind;
  }
  public A withKind(java.lang.String kind) {
    this.kind=kind; return (A) this;
  }
  public java.lang.Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
  }
  public java.lang.Boolean hasMetadata() {
    return this.metadata != null;
  }
  public GroupFluent.MetadataNested<A> withNewMetadata() {
    return new GroupFluentImpl.MetadataNestedImpl();
  }
  public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return new GroupFluentImpl.MetadataNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
  }
  public io.fabric8.openshift.api.model.GroupFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public A addToUsers(Integer index,java.lang.String item) {
    if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
    this.users.add(index, item);
    return (A)this;
  }
  public A setToUsers(java.lang.Integer index,java.lang.String item) {
    if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
    this.users.set(index, item); return (A)this;
  }
  public A addToUsers(java.lang.String... items) {
    if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.users.add(item);} return (A)this;
  }
  public A addAllToUsers(Collection<java.lang.String> items) {
    if (this.users == null) {this.users = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.users.add(item);} return (A)this;
  }
  public A removeFromUsers(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public A removeAllFromUsers(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.users!= null){ this.users.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getUsers() {
    return this.users;
  }
  public java.lang.String getUser(java.lang.Integer index) {
    return this.users.get(index);
  }
  public java.lang.String getFirstUser() {
    return this.users.get(0);
  }
  public java.lang.String getLastUser() {
    return this.users.get(users.size() - 1);
  }
  public java.lang.String getMatchingUser(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: users) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingUser(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: users) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsers(java.util.List<java.lang.String> users) {
    if (users != null) {this.users = new java.util.ArrayList(); for (java.lang.String item : users){this.addToUsers(item);}} else { this.users = null;} return (A) this;
  }
  public A withUsers(java.lang.String... users) {
    if (this.users != null) {this.users.clear();}
    if (users != null) {for (java.lang.String item :users){ this.addToUsers(item);}} return (A) this;
  }
  public java.lang.Boolean hasUsers() {
    return users != null && !users.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GroupFluentImpl that = (GroupFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (users != null ? !users.equals(that.users) :that.users != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  users,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (users != null && !users.isEmpty()) { sb.append("users:"); sb.append(users + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<GroupFluent.MetadataNested<N>> implements io.fabric8.openshift.api.model.GroupFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;
    public N and() {
      return (N) GroupFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}