package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GoogleIdentityProviderBuilder extends GoogleIdentityProviderFluentImpl<GoogleIdentityProviderBuilder> implements VisitableBuilder<GoogleIdentityProvider,io.fabric8.openshift.api.model.GoogleIdentityProviderBuilder>{
  public GoogleIdentityProviderBuilder() {
    this(false);
  }
  public GoogleIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(GoogleIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GoogleIdentityProvider(), validationEnabled);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GoogleIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GoogleIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withClientID(instance.getClientID()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withHostedDomain(instance.getHostedDomain()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProvider instance) {
    this(instance,false);
  }
  public GoogleIdentityProviderBuilder(io.fabric8.openshift.api.model.GoogleIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostedDomain(instance.getHostedDomain()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GoogleIdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GoogleIdentityProvider build() {
    GoogleIdentityProvider buildable = new GoogleIdentityProvider(fluent.getClientID(),fluent.getClientSecret(),fluent.getHostedDomain());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}