package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitSourceRevisionBuilder extends GitSourceRevisionFluentImpl<GitSourceRevisionBuilder> implements VisitableBuilder<GitSourceRevision,io.fabric8.openshift.api.model.GitSourceRevisionBuilder>{
  public GitSourceRevisionBuilder() {
    this(false);
  }
  public GitSourceRevisionBuilder(Boolean validationEnabled) {
    this(new GitSourceRevision(), validationEnabled);
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevisionFluent<?> fluent) {
    this(fluent, false);
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevisionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitSourceRevision(), validationEnabled);
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevisionFluent<?> fluent,io.fabric8.openshift.api.model.GitSourceRevision instance) {
    this(fluent, instance, false);
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevisionFluent<?> fluent,io.fabric8.openshift.api.model.GitSourceRevision instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthor(instance.getAuthor()); 
    fluent.withCommit(instance.getCommit()); 
    fluent.withCommitter(instance.getCommitter()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevision instance) {
    this(instance,false);
  }
  public GitSourceRevisionBuilder(io.fabric8.openshift.api.model.GitSourceRevision instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthor(instance.getAuthor()); 
    this.withCommit(instance.getCommit()); 
    this.withCommitter(instance.getCommitter()); 
    this.withMessage(instance.getMessage()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GitSourceRevisionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GitSourceRevision build() {
    GitSourceRevision buildable = new GitSourceRevision(fluent.getAuthor(),fluent.getCommit(),fluent.getCommitter(),fluent.getMessage());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}