package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubWebHookCauseBuilder extends GitHubWebHookCauseFluentImpl<GitHubWebHookCauseBuilder> implements VisitableBuilder<GitHubWebHookCause,io.fabric8.openshift.api.model.GitHubWebHookCauseBuilder>{
  public GitHubWebHookCauseBuilder() {
    this(false);
  }
  public GitHubWebHookCauseBuilder(Boolean validationEnabled) {
    this(new GitHubWebHookCause(), validationEnabled);
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCauseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitHubWebHookCause(), validationEnabled);
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCauseFluent<?> fluent,io.fabric8.openshift.api.model.GitHubWebHookCause instance) {
    this(fluent, instance, false);
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCauseFluent<?> fluent,io.fabric8.openshift.api.model.GitHubWebHookCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRevision(instance.getRevision()); 
    fluent.withSecret(instance.getSecret()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCause instance) {
    this(instance,false);
  }
  public GitHubWebHookCauseBuilder(io.fabric8.openshift.api.model.GitHubWebHookCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withRevision(instance.getRevision()); 
    this.withSecret(instance.getSecret()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GitHubWebHookCauseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GitHubWebHookCause build() {
    GitHubWebHookCause buildable = new GitHubWebHookCause(fluent.getRevision(),fluent.getSecret());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}