package io.fabric8.openshift.api.model;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GitHubIdentityProviderFluentImpl<A extends GitHubIdentityProviderFluent<A>> extends BaseFluent<A> implements GitHubIdentityProviderFluent<A>{
  public GitHubIdentityProviderFluentImpl() {
  }
  public GitHubIdentityProviderFluentImpl(io.fabric8.openshift.api.model.GitHubIdentityProvider instance) {
    this.withCa(instance.getCa()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostname(instance.getHostname()); 
    this.withOrganizations(instance.getOrganizations()); 
    this.withTeams(instance.getTeams()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ConfigMapNameReferenceBuilder ca;
  private String clientID;
  private SecretNameReferenceBuilder clientSecret;
  private java.lang.String hostname;
  private List<java.lang.String> organizations = new ArrayList<java.lang.String>();
  private java.util.List<java.lang.String> teams = new java.util.ArrayList<java.lang.String>();
  private Map<java.lang.String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildCa instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConfigMapNameReference getCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public io.fabric8.openshift.api.model.ConfigMapNameReference buildCa() {
    return this.ca!=null ?this.ca.build():null;
  }
  public A withCa(io.fabric8.openshift.api.model.ConfigMapNameReference ca) {
    _visitables.get("ca").remove(this.ca);
    if (ca!=null){ this.ca= new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(ca); _visitables.get("ca").add(this.ca);} return (A) this;
  }
  public Boolean hasCa() {
    return this.ca != null;
  }
  public A withNewCa(java.lang.String name) {
    return (A)withCa(new ConfigMapNameReference(name));
  }
  public GitHubIdentityProviderFluent.CaNested<A> withNewCa() {
    return new GitHubIdentityProviderFluentImpl.CaNestedImpl();
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> withNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
    return new GitHubIdentityProviderFluentImpl.CaNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editCa() {
    return withNewCaLike(getCa());
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editOrNewCa() {
    return withNewCaLike(getCa() != null ? getCa(): new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<A> editOrNewCaLike(io.fabric8.openshift.api.model.ConfigMapNameReference item) {
    return withNewCaLike(getCa() != null ? getCa(): item);
  }
  public java.lang.String getClientID() {
    return this.clientID;
  }
  public A withClientID(java.lang.String clientID) {
    this.clientID=clientID; return (A) this;
  }
  public java.lang.Boolean hasClientID() {
    return this.clientID != null;
  }
  
  /**
   * This method has been deprecated, please use method buildClientSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public SecretNameReference getClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public io.fabric8.openshift.api.model.SecretNameReference buildClientSecret() {
    return this.clientSecret!=null ?this.clientSecret.build():null;
  }
  public A withClientSecret(io.fabric8.openshift.api.model.SecretNameReference clientSecret) {
    _visitables.get("clientSecret").remove(this.clientSecret);
    if (clientSecret!=null){ this.clientSecret= new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(clientSecret); _visitables.get("clientSecret").add(this.clientSecret);} return (A) this;
  }
  public java.lang.Boolean hasClientSecret() {
    return this.clientSecret != null;
  }
  public A withNewClientSecret(java.lang.String name) {
    return (A)withClientSecret(new SecretNameReference(name));
  }
  public GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
    return new GitHubIdentityProviderFluentImpl.ClientSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return new io.fabric8.openshift.api.model.GitHubIdentityProviderFluentImpl.ClientSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
    return withNewClientSecretLike(getClientSecret());
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): new io.fabric8.openshift.api.model.SecretNameReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(io.fabric8.openshift.api.model.SecretNameReference item) {
    return withNewClientSecretLike(getClientSecret() != null ? getClientSecret(): item);
  }
  public java.lang.String getHostname() {
    return this.hostname;
  }
  public A withHostname(java.lang.String hostname) {
    this.hostname=hostname; return (A) this;
  }
  public java.lang.Boolean hasHostname() {
    return this.hostname != null;
  }
  public A addToOrganizations(Integer index,java.lang.String item) {
    if (this.organizations == null) {this.organizations = new java.util.ArrayList<java.lang.String>();}
    this.organizations.add(index, item);
    return (A)this;
  }
  public A setToOrganizations(java.lang.Integer index,java.lang.String item) {
    if (this.organizations == null) {this.organizations = new java.util.ArrayList<java.lang.String>();}
    this.organizations.set(index, item); return (A)this;
  }
  public A addToOrganizations(java.lang.String... items) {
    if (this.organizations == null) {this.organizations = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A addAllToOrganizations(Collection<java.lang.String> items) {
    if (this.organizations == null) {this.organizations = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.organizations.add(item);} return (A)this;
  }
  public A removeFromOrganizations(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public A removeAllFromOrganizations(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.organizations!= null){ this.organizations.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getOrganizations() {
    return this.organizations;
  }
  public java.lang.String getOrganization(java.lang.Integer index) {
    return this.organizations.get(index);
  }
  public java.lang.String getFirstOrganization() {
    return this.organizations.get(0);
  }
  public java.lang.String getLastOrganization() {
    return this.organizations.get(organizations.size() - 1);
  }
  public java.lang.String getMatchingOrganization(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: organizations) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingOrganization(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: organizations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withOrganizations(java.util.List<java.lang.String> organizations) {
    if (organizations != null) {this.organizations = new java.util.ArrayList(); for (java.lang.String item : organizations){this.addToOrganizations(item);}} else { this.organizations = null;} return (A) this;
  }
  public A withOrganizations(java.lang.String... organizations) {
    if (this.organizations != null) {this.organizations.clear();}
    if (organizations != null) {for (java.lang.String item :organizations){ this.addToOrganizations(item);}} return (A) this;
  }
  public java.lang.Boolean hasOrganizations() {
    return organizations != null && !organizations.isEmpty();
  }
  public A addToTeams(java.lang.Integer index,java.lang.String item) {
    if (this.teams == null) {this.teams = new java.util.ArrayList<java.lang.String>();}
    this.teams.add(index, item);
    return (A)this;
  }
  public A setToTeams(java.lang.Integer index,java.lang.String item) {
    if (this.teams == null) {this.teams = new java.util.ArrayList<java.lang.String>();}
    this.teams.set(index, item); return (A)this;
  }
  public A addToTeams(java.lang.String... items) {
    if (this.teams == null) {this.teams = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.teams.add(item);} return (A)this;
  }
  public A addAllToTeams(java.util.Collection<java.lang.String> items) {
    if (this.teams == null) {this.teams = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.teams.add(item);} return (A)this;
  }
  public A removeFromTeams(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
  }
  public A removeAllFromTeams(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.teams!= null){ this.teams.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getTeams() {
    return this.teams;
  }
  public java.lang.String getTeam(java.lang.Integer index) {
    return this.teams.get(index);
  }
  public java.lang.String getFirstTeam() {
    return this.teams.get(0);
  }
  public java.lang.String getLastTeam() {
    return this.teams.get(teams.size() - 1);
  }
  public java.lang.String getMatchingTeam(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: teams) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingTeam(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: teams) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTeams(java.util.List<java.lang.String> teams) {
    if (teams != null) {this.teams = new java.util.ArrayList(); for (java.lang.String item : teams){this.addToTeams(item);}} else { this.teams = null;} return (A) this;
  }
  public A withTeams(java.lang.String... teams) {
    if (this.teams != null) {this.teams.clear();}
    if (teams != null) {for (java.lang.String item :teams){ this.addToTeams(item);}} return (A) this;
  }
  public java.lang.Boolean hasTeams() {
    return teams != null && !teams.isEmpty();
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GitHubIdentityProviderFluentImpl that = (GitHubIdentityProviderFluentImpl) o;
    if (ca != null ? !ca.equals(that.ca) :that.ca != null) return false;
    if (clientID != null ? !clientID.equals(that.clientID) :that.clientID != null) return false;
    if (clientSecret != null ? !clientSecret.equals(that.clientSecret) :that.clientSecret != null) return false;
    if (hostname != null ? !hostname.equals(that.hostname) :that.hostname != null) return false;
    if (organizations != null ? !organizations.equals(that.organizations) :that.organizations != null) return false;
    if (teams != null ? !teams.equals(that.teams) :that.teams != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ca,  clientID,  clientSecret,  hostname,  organizations,  teams,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ca != null) { sb.append("ca:"); sb.append(ca + ","); }
    if (clientID != null) { sb.append("clientID:"); sb.append(clientID + ","); }
    if (clientSecret != null) { sb.append("clientSecret:"); sb.append(clientSecret + ","); }
    if (hostname != null) { sb.append("hostname:"); sb.append(hostname + ","); }
    if (organizations != null && !organizations.isEmpty()) { sb.append("organizations:"); sb.append(organizations + ","); }
    if (teams != null && !teams.isEmpty()) { sb.append("teams:"); sb.append(teams + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class CaNestedImpl<N> extends ConfigMapNameReferenceFluentImpl<GitHubIdentityProviderFluent.CaNested<N>> implements io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.CaNested<N>,Nested<N>{
    CaNestedImpl(ConfigMapNameReference item) {
      this.builder = new ConfigMapNameReferenceBuilder(this, item);
    }
    CaNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.ConfigMapNameReferenceBuilder builder;
    public N and() {
      return (N) GitHubIdentityProviderFluentImpl.this.withCa(builder.build());
    }
    public N endCa() {
      return and();
    }
    
  }
  class ClientSecretNestedImpl<N> extends SecretNameReferenceFluentImpl<GitHubIdentityProviderFluent.ClientSecretNested<N>> implements io.fabric8.openshift.api.model.GitHubIdentityProviderFluent.ClientSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ClientSecretNestedImpl(SecretNameReference item) {
      this.builder = new SecretNameReferenceBuilder(this, item);
    }
    ClientSecretNestedImpl() {
      this.builder = new io.fabric8.openshift.api.model.SecretNameReferenceBuilder(this);
    }
    io.fabric8.openshift.api.model.SecretNameReferenceBuilder builder;
    public N and() {
      return (N) GitHubIdentityProviderFluentImpl.this.withClientSecret(builder.build());
    }
    public N endClientSecret() {
      return and();
    }
    
  }
  
}