package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitHubIdentityProviderBuilder extends GitHubIdentityProviderFluentImpl<GitHubIdentityProviderBuilder> implements VisitableBuilder<GitHubIdentityProvider,io.fabric8.openshift.api.model.GitHubIdentityProviderBuilder>{
  public GitHubIdentityProviderBuilder() {
    this(false);
  }
  public GitHubIdentityProviderBuilder(Boolean validationEnabled) {
    this(new GitHubIdentityProvider(), validationEnabled);
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProviderFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitHubIdentityProvider(), validationEnabled);
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GitHubIdentityProvider instance) {
    this(fluent, instance, false);
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProviderFluent<?> fluent,io.fabric8.openshift.api.model.GitHubIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withClientID(instance.getClientID()); 
    fluent.withClientSecret(instance.getClientSecret()); 
    fluent.withHostname(instance.getHostname()); 
    fluent.withOrganizations(instance.getOrganizations()); 
    fluent.withTeams(instance.getTeams()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProvider instance) {
    this(instance,false);
  }
  public GitHubIdentityProviderBuilder(io.fabric8.openshift.api.model.GitHubIdentityProvider instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withClientID(instance.getClientID()); 
    this.withClientSecret(instance.getClientSecret()); 
    this.withHostname(instance.getHostname()); 
    this.withOrganizations(instance.getOrganizations()); 
    this.withTeams(instance.getTeams()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GitHubIdentityProviderFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GitHubIdentityProvider build() {
    GitHubIdentityProvider buildable = new GitHubIdentityProvider(fluent.getCa(),fluent.getClientID(),fluent.getClientSecret(),fluent.getHostname(),fluent.getOrganizations(),fluent.getTeams());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}