package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GitBuildSourceBuilder extends GitBuildSourceFluentImpl<GitBuildSourceBuilder> implements VisitableBuilder<GitBuildSource,io.fabric8.openshift.api.model.GitBuildSourceBuilder>{
  public GitBuildSourceBuilder() {
    this(false);
  }
  public GitBuildSourceBuilder(Boolean validationEnabled) {
    this(new GitBuildSource(), validationEnabled);
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new GitBuildSource(), validationEnabled);
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.GitBuildSource instance) {
    this(fluent, instance, false);
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.GitBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttpProxy(instance.getHttpProxy()); 
    fluent.withHttpsProxy(instance.getHttpsProxy()); 
    fluent.withNoProxy(instance.getNoProxy()); 
    fluent.withRef(instance.getRef()); 
    fluent.withUri(instance.getUri()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSource instance) {
    this(instance,false);
  }
  public GitBuildSourceBuilder(io.fabric8.openshift.api.model.GitBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttpProxy(instance.getHttpProxy()); 
    this.withHttpsProxy(instance.getHttpsProxy()); 
    this.withNoProxy(instance.getNoProxy()); 
    this.withRef(instance.getRef()); 
    this.withUri(instance.getUri()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.GitBuildSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.GitBuildSource build() {
    GitBuildSource buildable = new GitBuildSource(fluent.getHttpProxy(),fluent.getHttpsProxy(),fluent.getNoProxy(),fluent.getRef(),fluent.getUri());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}