package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class FeatureGateListBuilder extends FeatureGateListFluentImpl<FeatureGateListBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.FeatureGateList,io.fabric8.openshift.api.model.FeatureGateListBuilder>{
  public FeatureGateListBuilder() {
    this(false);
  }
  public FeatureGateListBuilder(Boolean validationEnabled) {
    this(new FeatureGateList(), validationEnabled);
  }
  public FeatureGateListBuilder(FeatureGateListFluent<?> fluent) {
    this(fluent, false);
  }
  public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new FeatureGateList(), validationEnabled);
  }
  public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateList instance) {
    this(fluent, instance, false);
  }
  public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent,io.fabric8.openshift.api.model.FeatureGateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateList instance) {
    this(instance,false);
  }
  public FeatureGateListBuilder(io.fabric8.openshift.api.model.FeatureGateList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.FeatureGateListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.FeatureGateList build() {
    FeatureGateList buildable = new FeatureGateList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}