package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalIPConfigBuilder extends ExternalIPConfigFluentImpl<ExternalIPConfigBuilder> implements VisitableBuilder<ExternalIPConfig,io.fabric8.openshift.api.model.ExternalIPConfigBuilder>{
  public ExternalIPConfigBuilder() {
    this(false);
  }
  public ExternalIPConfigBuilder(Boolean validationEnabled) {
    this(new ExternalIPConfig(), validationEnabled);
  }
  public ExternalIPConfigBuilder(ExternalIPConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ExternalIPConfig(), validationEnabled);
  }
  public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPConfig instance) {
    this(fluent, instance, false);
  }
  public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent,io.fabric8.openshift.api.model.ExternalIPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAutoAssignCIDRs(instance.getAutoAssignCIDRs()); 
    fluent.withPolicy(instance.getPolicy()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfig instance) {
    this(instance,false);
  }
  public ExternalIPConfigBuilder(io.fabric8.openshift.api.model.ExternalIPConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAutoAssignCIDRs(instance.getAutoAssignCIDRs()); 
    this.withPolicy(instance.getPolicy()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ExternalIPConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ExternalIPConfig build() {
    ExternalIPConfig buildable = new ExternalIPConfig(fluent.getAutoAssignCIDRs(),fluent.getPolicy());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}