package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EgressNetworkPolicySpecBuilder extends EgressNetworkPolicySpecFluentImpl<EgressNetworkPolicySpecBuilder> implements VisitableBuilder<EgressNetworkPolicySpec,io.fabric8.openshift.api.model.EgressNetworkPolicySpecBuilder>{
  public EgressNetworkPolicySpecBuilder() {
    this(false);
  }
  public EgressNetworkPolicySpecBuilder(Boolean validationEnabled) {
    this(new EgressNetworkPolicySpec(), validationEnabled);
  }
  public EgressNetworkPolicySpecBuilder(EgressNetworkPolicySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EgressNetworkPolicySpecBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new EgressNetworkPolicySpec(), validationEnabled);
  }
  public EgressNetworkPolicySpecBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicySpec instance) {
    this(fluent, instance, false);
  }
  public EgressNetworkPolicySpecBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent<?> fluent,io.fabric8.openshift.api.model.EgressNetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEgress(instance.getEgress()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EgressNetworkPolicySpecBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicySpec instance) {
    this(instance,false);
  }
  public EgressNetworkPolicySpecBuilder(io.fabric8.openshift.api.model.EgressNetworkPolicySpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEgress(instance.getEgress()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.EgressNetworkPolicySpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.EgressNetworkPolicySpec build() {
    EgressNetworkPolicySpec buildable = new EgressNetworkPolicySpec(fluent.getEgress());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}