package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ObjectReference;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DockerBuildStrategyFluentImpl<A extends DockerBuildStrategyFluent<A>> extends BaseFluent<A> implements DockerBuildStrategyFluent<A>{
  public DockerBuildStrategyFluentImpl() {
  }
  public DockerBuildStrategyFluentImpl(io.fabric8.openshift.api.model.DockerBuildStrategy instance) {
    this.withBuildArgs(instance.getBuildArgs()); 
    this.withDockerfilePath(instance.getDockerfilePath()); 
    this.withEnv(instance.getEnv()); 
    this.withForcePull(instance.getForcePull()); 
    this.withFrom(instance.getFrom()); 
    this.withImageOptimizationPolicy(instance.getImageOptimizationPolicy()); 
    this.withNoCache(instance.getNoCache()); 
    this.withPullSecret(instance.getPullSecret()); 
    this.withVolumes(instance.getVolumes()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private List<EnvVar> buildArgs = new ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private String dockerfilePath;
  private java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();
  private Boolean forcePull;
  private ObjectReferenceBuilder from;
  private java.lang.String imageOptimizationPolicy;
  private java.lang.Boolean noCache;
  private LocalObjectReferenceBuilder pullSecret;
  private java.util.ArrayList<BuildVolumeBuilder> volumes = new java.util.ArrayList<BuildVolumeBuilder>();
  private Map<java.lang.String,Object> additionalProperties;
  public A addToBuildArgs(Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.buildArgs.add(index, item);
    return (A)this;
  }
  public A setToBuildArgs(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.buildArgs.set(index, item); return (A)this;
  }
  public A addToBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A addAllToBuildArgs(Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.buildArgs == null) {this.buildArgs = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.buildArgs.add(item);} return (A)this;
  }
  public A removeFromBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public A removeAllFromBuildArgs(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.buildArgs!= null){ this.buildArgs.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getBuildArgs() {
    return this.buildArgs;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getBuildArg(java.lang.Integer index) {
    return this.buildArgs.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstBuildArg() {
    return this.buildArgs.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastBuildArg() {
    return this.buildArgs.get(buildArgs.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingBuildArg(Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: buildArgs) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingBuildArg(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: buildArgs) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withBuildArgs(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> buildArgs) {
    if (buildArgs != null) {this.buildArgs = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EnvVar item : buildArgs){this.addToBuildArgs(item);}} else { this.buildArgs = null;} return (A) this;
  }
  public A withBuildArgs(io.fabric8.kubernetes.api.model.EnvVar... buildArgs) {
    if (this.buildArgs != null) {this.buildArgs.clear();}
    if (buildArgs != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :buildArgs){ this.addToBuildArgs(item);}} return (A) this;
  }
  public java.lang.Boolean hasBuildArgs() {
    return buildArgs != null && !buildArgs.isEmpty();
  }
  public java.lang.String getDockerfilePath() {
    return this.dockerfilePath;
  }
  public A withDockerfilePath(java.lang.String dockerfilePath) {
    this.dockerfilePath=dockerfilePath; return (A) this;
  }
  public java.lang.Boolean hasDockerfilePath() {
    return this.dockerfilePath != null;
  }
  public A addToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.add(index, item);
    return (A)this;
  }
  public A setToEnv(java.lang.Integer index,io.fabric8.kubernetes.api.model.EnvVar item) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    this.env.set(index, item); return (A)this;
  }
  public A addToEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A addAllToEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    if (this.env == null) {this.env = new java.util.ArrayList<io.fabric8.kubernetes.api.model.EnvVar>();}
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {this.env.add(item);} return (A)this;
  }
  public A removeFromEnv(io.fabric8.kubernetes.api.model.EnvVar... items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public A removeAllFromEnv(java.util.Collection<io.fabric8.kubernetes.api.model.EnvVar> items) {
    for (io.fabric8.kubernetes.api.model.EnvVar item : items) {if (this.env!= null){ this.env.remove(item);}} return (A)this;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.EnvVar> getEnv() {
    return this.env;
  }
  public io.fabric8.kubernetes.api.model.EnvVar getEnv(java.lang.Integer index) {
    return this.env.get(index);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getFirstEnv() {
    return this.env.get(0);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getLastEnv() {
    return this.env.get(env.size() - 1);
  }
  public io.fabric8.kubernetes.api.model.EnvVar getMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.fabric8.kubernetes.api.model.EnvVar> predicate) {
    for (io.fabric8.kubernetes.api.model.EnvVar item: env) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEnv(java.util.List<io.fabric8.kubernetes.api.model.EnvVar> env) {
    if (env != null) {this.env = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.EnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
  }
  public A withEnv(io.fabric8.kubernetes.api.model.EnvVar... env) {
    if (this.env != null) {this.env.clear();}
    if (env != null) {for (io.fabric8.kubernetes.api.model.EnvVar item :env){ this.addToEnv(item);}} return (A) this;
  }
  public java.lang.Boolean hasEnv() {
    return env != null && !env.isEmpty();
  }
  public java.lang.Boolean getForcePull() {
    return this.forcePull;
  }
  public A withForcePull(java.lang.Boolean forcePull) {
    this.forcePull=forcePull; return (A) this;
  }
  public java.lang.Boolean hasForcePull() {
    return this.forcePull != null;
  }
  
  /**
   * This method has been deprecated, please use method buildFrom instead.
   * @return The buildable object.
   */
  @Deprecated
  public io.fabric8.kubernetes.api.model.ObjectReference getFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public io.fabric8.kubernetes.api.model.ObjectReference buildFrom() {
    return this.from!=null ?this.from.build():null;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.ObjectReference from) {
    _visitables.get("from").remove(this.from);
    if (from!=null){ this.from= new ObjectReferenceBuilder(from); _visitables.get("from").add(this.from);} return (A) this;
  }
  public java.lang.Boolean hasFrom() {
    return this.from != null;
  }
  public DockerBuildStrategyFluent.FromNested<A> withNewFrom() {
    return new DockerBuildStrategyFluentImpl.FromNestedImpl();
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> withNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return new DockerBuildStrategyFluentImpl.FromNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editFrom() {
    return withNewFromLike(getFrom());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editOrNewFrom() {
    return withNewFromLike(getFrom() != null ? getFrom(): new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<A> editOrNewFromLike(io.fabric8.kubernetes.api.model.ObjectReference item) {
    return withNewFromLike(getFrom() != null ? getFrom(): item);
  }
  public java.lang.String getImageOptimizationPolicy() {
    return this.imageOptimizationPolicy;
  }
  public A withImageOptimizationPolicy(java.lang.String imageOptimizationPolicy) {
    this.imageOptimizationPolicy=imageOptimizationPolicy; return (A) this;
  }
  public java.lang.Boolean hasImageOptimizationPolicy() {
    return this.imageOptimizationPolicy != null;
  }
  public java.lang.Boolean getNoCache() {
    return this.noCache;
  }
  public A withNoCache(java.lang.Boolean noCache) {
    this.noCache=noCache; return (A) this;
  }
  public java.lang.Boolean hasNoCache() {
    return this.noCache != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPullSecret instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public LocalObjectReference getPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public io.fabric8.kubernetes.api.model.LocalObjectReference buildPullSecret() {
    return this.pullSecret!=null ?this.pullSecret.build():null;
  }
  public A withPullSecret(io.fabric8.kubernetes.api.model.LocalObjectReference pullSecret) {
    _visitables.get("pullSecret").remove(this.pullSecret);
    if (pullSecret!=null){ this.pullSecret= new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(pullSecret); _visitables.get("pullSecret").add(this.pullSecret);} return (A) this;
  }
  public java.lang.Boolean hasPullSecret() {
    return this.pullSecret != null;
  }
  public A withNewPullSecret(java.lang.String name) {
    return (A)withPullSecret(new LocalObjectReference(name));
  }
  public DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecret() {
    return new DockerBuildStrategyFluentImpl.PullSecretNestedImpl();
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.PullSecretNestedImpl(item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editPullSecret() {
    return withNewPullSecretLike(getPullSecret());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecret() {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder().build());
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<A> editOrNewPullSecretLike(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
    return withNewPullSecretLike(getPullSecret() != null ? getPullSecret(): item);
  }
  public A addToVolumes(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
  }
  public A setToVolumes(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);
    if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
    if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
     return (A)this;
  }
  public A addToVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A addAllToVolumes(java.util.Collection<io.fabric8.openshift.api.model.BuildVolume> items) {
    if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.openshift.api.model.BuildVolumeBuilder>();}
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
  }
  public A removeFromVolumes(io.fabric8.openshift.api.model.BuildVolume... items) {
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumes(java.util.Collection<io.fabric8.openshift.api.model.BuildVolume> items) {
    for (io.fabric8.openshift.api.model.BuildVolume item : items) {io.fabric8.openshift.api.model.BuildVolumeBuilder builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumes(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    if (volumes == null) return (A) this;
    final Iterator<io.fabric8.openshift.api.model.BuildVolumeBuilder> each = volumes.iterator();
    final List visitables = _visitables.get("volumes");
    while (each.hasNext()) {
      io.fabric8.openshift.api.model.BuildVolumeBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumes instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.openshift.api.model.BuildVolume> getVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public java.util.List<io.fabric8.openshift.api.model.BuildVolume> buildVolumes() {
    return volumes != null ? build(volumes) : null;
  }
  public io.fabric8.openshift.api.model.BuildVolume buildVolume(java.lang.Integer index) {
    return this.volumes.get(index).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildFirstVolume() {
    return this.volumes.get(0).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildLastVolume() {
    return this.volumes.get(volumes.size() - 1).build();
  }
  public io.fabric8.openshift.api.model.BuildVolume buildMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    for (io.fabric8.openshift.api.model.BuildVolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumes(java.util.List<io.fabric8.openshift.api.model.BuildVolume> volumes) {
    if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
    if (volumes != null) {this.volumes = new java.util.ArrayList(); for (io.fabric8.openshift.api.model.BuildVolume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
  }
  public A withVolumes(io.fabric8.openshift.api.model.BuildVolume... volumes) {
    if (this.volumes != null) {this.volumes.clear();}
    if (volumes != null) {for (io.fabric8.openshift.api.model.BuildVolume item :volumes){ this.addToVolumes(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumes() {
    return volumes != null && !volumes.isEmpty();
  }
  public DockerBuildStrategyFluent.VolumesNested<A> addNewVolume() {
    return new DockerBuildStrategyFluentImpl.VolumesNestedImpl();
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> addNewVolumeLike(io.fabric8.openshift.api.model.BuildVolume item) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.VolumesNestedImpl(-1, item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> setNewVolumeLike(java.lang.Integer index,io.fabric8.openshift.api.model.BuildVolume item) {
    return new io.fabric8.openshift.api.model.DockerBuildStrategyFluentImpl.VolumesNestedImpl(index, item);
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> editVolume(java.lang.Integer index) {
    if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> editFirstVolume() {
    if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
    return setNewVolumeLike(0, buildVolume(0));
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> editLastVolume() {
    int index = volumes.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<A> editMatchingVolume(java.util.function.Predicate<io.fabric8.openshift.api.model.BuildVolumeBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumes.size();i++) { 
    if (predicate.test(volumes.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
    return setNewVolumeLike(index, buildVolume(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    DockerBuildStrategyFluentImpl that = (DockerBuildStrategyFluentImpl) o;
    if (buildArgs != null ? !buildArgs.equals(that.buildArgs) :that.buildArgs != null) return false;
    if (dockerfilePath != null ? !dockerfilePath.equals(that.dockerfilePath) :that.dockerfilePath != null) return false;
    if (env != null ? !env.equals(that.env) :that.env != null) return false;
    if (forcePull != null ? !forcePull.equals(that.forcePull) :that.forcePull != null) return false;
    if (from != null ? !from.equals(that.from) :that.from != null) return false;
    if (imageOptimizationPolicy != null ? !imageOptimizationPolicy.equals(that.imageOptimizationPolicy) :that.imageOptimizationPolicy != null) return false;
    if (noCache != null ? !noCache.equals(that.noCache) :that.noCache != null) return false;
    if (pullSecret != null ? !pullSecret.equals(that.pullSecret) :that.pullSecret != null) return false;
    if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(buildArgs,  dockerfilePath,  env,  forcePull,  from,  imageOptimizationPolicy,  noCache,  pullSecret,  volumes,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (buildArgs != null && !buildArgs.isEmpty()) { sb.append("buildArgs:"); sb.append(buildArgs + ","); }
    if (dockerfilePath != null) { sb.append("dockerfilePath:"); sb.append(dockerfilePath + ","); }
    if (env != null && !env.isEmpty()) { sb.append("env:"); sb.append(env + ","); }
    if (forcePull != null) { sb.append("forcePull:"); sb.append(forcePull + ","); }
    if (from != null) { sb.append("from:"); sb.append(from + ","); }
    if (imageOptimizationPolicy != null) { sb.append("imageOptimizationPolicy:"); sb.append(imageOptimizationPolicy + ","); }
    if (noCache != null) { sb.append("noCache:"); sb.append(noCache + ","); }
    if (pullSecret != null) { sb.append("pullSecret:"); sb.append(pullSecret + ","); }
    if (volumes != null && !volumes.isEmpty()) { sb.append("volumes:"); sb.append(volumes + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withForcePull() {
    return withForcePull(true);
  }
  public A withNoCache() {
    return withNoCache(true);
  }
  class FromNestedImpl<N> extends ObjectReferenceFluentImpl<DockerBuildStrategyFluent.FromNested<N>> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent.FromNested<N>,Nested<N>{
    FromNestedImpl(io.fabric8.kubernetes.api.model.ObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this, item);
    }
    FromNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.ObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.ObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withFrom(builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  class PullSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<DockerBuildStrategyFluent.PullSecretNested<N>> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent.PullSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    PullSecretNestedImpl(io.fabric8.kubernetes.api.model.LocalObjectReference item) {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this, item);
    }
    PullSecretNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder builder;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.withPullSecret(builder.build());
    }
    public N endPullSecret() {
      return and();
    }
    
  }
  class VolumesNestedImpl<N> extends BuildVolumeFluentImpl<DockerBuildStrategyFluent.VolumesNested<N>> implements io.fabric8.openshift.api.model.DockerBuildStrategyFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumesNestedImpl(java.lang.Integer index,BuildVolume item) {
      this.index = index;
      this.builder = new BuildVolumeBuilder(this, item);
    }
    VolumesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.openshift.api.model.BuildVolumeBuilder(this);
    }
    io.fabric8.openshift.api.model.BuildVolumeBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) DockerBuildStrategyFluentImpl.this.setToVolumes(index,builder.build());
    }
    public N endVolume() {
      return and();
    }
    
  }
  
}