package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigStatusBuilder extends DeploymentConfigStatusFluentImpl<DeploymentConfigStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DeploymentConfigStatus,io.fabric8.openshift.api.model.DeploymentConfigStatusBuilder>{
  public DeploymentConfigStatusBuilder() {
    this(false);
  }
  public DeploymentConfigStatusBuilder(Boolean validationEnabled) {
    this(new DeploymentConfigStatus(), validationEnabled);
  }
  public DeploymentConfigStatusBuilder(DeploymentConfigStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigStatusBuilder(io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentConfigStatus(), validationEnabled);
  }
  public DeploymentConfigStatusBuilder(io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigStatus instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigStatusBuilder(io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withDetails(instance.getDetails()); 
    fluent.withLatestVersion(instance.getLatestVersion()); 
    fluent.withObservedGeneration(instance.getObservedGeneration()); 
    fluent.withReadyReplicas(instance.getReadyReplicas()); 
    fluent.withReplicas(instance.getReplicas()); 
    fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigStatusBuilder(io.fabric8.openshift.api.model.DeploymentConfigStatus instance) {
    this(instance,false);
  }
  public DeploymentConfigStatusBuilder(io.fabric8.openshift.api.model.DeploymentConfigStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAvailableReplicas(instance.getAvailableReplicas()); 
    this.withConditions(instance.getConditions()); 
    this.withDetails(instance.getDetails()); 
    this.withLatestVersion(instance.getLatestVersion()); 
    this.withObservedGeneration(instance.getObservedGeneration()); 
    this.withReadyReplicas(instance.getReadyReplicas()); 
    this.withReplicas(instance.getReplicas()); 
    this.withUnavailableReplicas(instance.getUnavailableReplicas()); 
    this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentConfigStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentConfigStatus build() {
    DeploymentConfigStatus buildable = new DeploymentConfigStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getDetails(),fluent.getLatestVersion(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}