package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentConfigListBuilder extends DeploymentConfigListFluentImpl<DeploymentConfigListBuilder> implements VisitableBuilder<DeploymentConfigList,io.fabric8.openshift.api.model.DeploymentConfigListBuilder>{
  public DeploymentConfigListBuilder() {
    this(false);
  }
  public DeploymentConfigListBuilder(Boolean validationEnabled) {
    this(new DeploymentConfigList(), validationEnabled);
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigListFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentConfigList(), validationEnabled);
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigListFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigList instance) {
    this(fluent, instance, false);
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigListFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentConfigList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigList instance) {
    this(instance,false);
  }
  public DeploymentConfigListBuilder(io.fabric8.openshift.api.model.DeploymentConfigList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentConfigListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentConfigList build() {
    DeploymentConfigList buildable = new DeploymentConfigList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}