package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentCauseBuilder extends DeploymentCauseFluentImpl<DeploymentCauseBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DeploymentCause,io.fabric8.openshift.api.model.DeploymentCauseBuilder>{
  public DeploymentCauseBuilder() {
    this(false);
  }
  public DeploymentCauseBuilder(Boolean validationEnabled) {
    this(new DeploymentCause(), validationEnabled);
  }
  public DeploymentCauseBuilder(DeploymentCauseFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentCauseBuilder(io.fabric8.openshift.api.model.DeploymentCauseFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DeploymentCause(), validationEnabled);
  }
  public DeploymentCauseBuilder(io.fabric8.openshift.api.model.DeploymentCauseFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentCause instance) {
    this(fluent, instance, false);
  }
  public DeploymentCauseBuilder(io.fabric8.openshift.api.model.DeploymentCauseFluent<?> fluent,io.fabric8.openshift.api.model.DeploymentCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withImageTrigger(instance.getImageTrigger()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DeploymentCauseBuilder(io.fabric8.openshift.api.model.DeploymentCause instance) {
    this(instance,false);
  }
  public DeploymentCauseBuilder(io.fabric8.openshift.api.model.DeploymentCause instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withImageTrigger(instance.getImageTrigger()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DeploymentCauseFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DeploymentCause build() {
    DeploymentCause buildable = new DeploymentCause(fluent.getImageTrigger(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}