package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DNSBuilder extends DNSFluentImpl<DNSBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.DNS,DNSBuilder>{
  public DNSBuilder() {
    this(false);
  }
  public DNSBuilder(Boolean validationEnabled) {
    this(new DNS(), validationEnabled);
  }
  public DNSBuilder(DNSFluent<?> fluent) {
    this(fluent, false);
  }
  public DNSBuilder(io.fabric8.openshift.api.model.DNSFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new DNS(), validationEnabled);
  }
  public DNSBuilder(io.fabric8.openshift.api.model.DNSFluent<?> fluent,io.fabric8.openshift.api.model.DNS instance) {
    this(fluent, instance, false);
  }
  public DNSBuilder(io.fabric8.openshift.api.model.DNSFluent<?> fluent,io.fabric8.openshift.api.model.DNS instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public DNSBuilder(io.fabric8.openshift.api.model.DNS instance) {
    this(instance,false);
  }
  public DNSBuilder(io.fabric8.openshift.api.model.DNS instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.DNSFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.DNS build() {
    DNS buildable = new DNS(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}