package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomTLSProfileBuilder extends CustomTLSProfileFluentImpl<CustomTLSProfileBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.CustomTLSProfile,CustomTLSProfileBuilder>{
  public CustomTLSProfileBuilder() {
    this(false);
  }
  public CustomTLSProfileBuilder(Boolean validationEnabled) {
    this(new CustomTLSProfile(), validationEnabled);
  }
  public CustomTLSProfileBuilder(CustomTLSProfileFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomTLSProfileBuilder(io.fabric8.openshift.api.model.CustomTLSProfileFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CustomTLSProfile(), validationEnabled);
  }
  public CustomTLSProfileBuilder(io.fabric8.openshift.api.model.CustomTLSProfileFluent<?> fluent,io.fabric8.openshift.api.model.CustomTLSProfile instance) {
    this(fluent, instance, false);
  }
  public CustomTLSProfileBuilder(io.fabric8.openshift.api.model.CustomTLSProfileFluent<?> fluent,io.fabric8.openshift.api.model.CustomTLSProfile instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCiphers(instance.getCiphers()); 
    fluent.withMinTLSVersion(instance.getMinTLSVersion()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomTLSProfileBuilder(io.fabric8.openshift.api.model.CustomTLSProfile instance) {
    this(instance,false);
  }
  public CustomTLSProfileBuilder(io.fabric8.openshift.api.model.CustomTLSProfile instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCiphers(instance.getCiphers()); 
    this.withMinTLSVersion(instance.getMinTLSVersion()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.CustomTLSProfileFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.CustomTLSProfile build() {
    CustomTLSProfile buildable = new CustomTLSProfile(fluent.getCiphers(),fluent.getMinTLSVersion());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}