package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomFeatureGatesBuilder extends CustomFeatureGatesFluentImpl<CustomFeatureGatesBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.CustomFeatureGates,io.fabric8.openshift.api.model.CustomFeatureGatesBuilder>{
  public CustomFeatureGatesBuilder() {
    this(false);
  }
  public CustomFeatureGatesBuilder(Boolean validationEnabled) {
    this(new CustomFeatureGates(), validationEnabled);
  }
  public CustomFeatureGatesBuilder(CustomFeatureGatesFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomFeatureGatesBuilder(io.fabric8.openshift.api.model.CustomFeatureGatesFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CustomFeatureGates(), validationEnabled);
  }
  public CustomFeatureGatesBuilder(io.fabric8.openshift.api.model.CustomFeatureGatesFluent<?> fluent,io.fabric8.openshift.api.model.CustomFeatureGates instance) {
    this(fluent, instance, false);
  }
  public CustomFeatureGatesBuilder(io.fabric8.openshift.api.model.CustomFeatureGatesFluent<?> fluent,io.fabric8.openshift.api.model.CustomFeatureGates instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withDisabled(instance.getDisabled()); 
    fluent.withEnabled(instance.getEnabled()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomFeatureGatesBuilder(io.fabric8.openshift.api.model.CustomFeatureGates instance) {
    this(instance,false);
  }
  public CustomFeatureGatesBuilder(io.fabric8.openshift.api.model.CustomFeatureGates instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withDisabled(instance.getDisabled()); 
    this.withEnabled(instance.getEnabled()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.CustomFeatureGatesFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.CustomFeatureGates build() {
    CustomFeatureGates buildable = new CustomFeatureGates(fluent.getDisabled(),fluent.getEnabled());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}