package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleStatusBuilder extends ConsoleStatusFluentImpl<ConsoleStatusBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ConsoleStatus,ConsoleStatusBuilder>{
  public ConsoleStatusBuilder() {
    this(false);
  }
  public ConsoleStatusBuilder(Boolean validationEnabled) {
    this(new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleStatus(), validationEnabled);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleStatus instance) {
    this(fluent, instance, false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConsoleURL(instance.getConsoleURL()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatus instance) {
    this(instance,false);
  }
  public ConsoleStatusBuilder(io.fabric8.openshift.api.model.ConsoleStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConsoleURL(instance.getConsoleURL()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleStatus build() {
    ConsoleStatus buildable = new ConsoleStatus(fluent.getConsoleURL());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}