package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleSpecBuilder extends ConsoleSpecFluentImpl<ConsoleSpecBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ConsoleSpec,io.fabric8.openshift.api.model.ConsoleSpecBuilder>{
  public ConsoleSpecBuilder() {
    this(false);
  }
  public ConsoleSpecBuilder(Boolean validationEnabled) {
    this(new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(ConsoleSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConsoleSpec(), validationEnabled);
  }
  public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleSpec instance) {
    this(fluent, instance, false);
  }
  public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent,io.fabric8.openshift.api.model.ConsoleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAuthentication(instance.getAuthentication()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpec instance) {
    this(instance,false);
  }
  public ConsoleSpecBuilder(io.fabric8.openshift.api.model.ConsoleSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAuthentication(instance.getAuthentication()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConsoleSpec build() {
    ConsoleSpec buildable = new ConsoleSpec(fluent.getAuthentication());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}