package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConsoleBuilder extends ConsoleFluentImpl<ConsoleBuilder> implements VisitableBuilder<Console,io.fabric8.openshift.api.model.ConsoleBuilder>{
  public ConsoleBuilder() {
    this(false);
  }
  public ConsoleBuilder(Boolean validationEnabled) {
    this(new Console(), validationEnabled);
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.ConsoleFluent<?> fluent) {
    this(fluent, false);
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.ConsoleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Console(), validationEnabled);
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.ConsoleFluent<?> fluent,io.fabric8.openshift.api.model.Console instance) {
    this(fluent, instance, false);
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.ConsoleFluent<?> fluent,io.fabric8.openshift.api.model.Console instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.Console instance) {
    this(instance,false);
  }
  public ConsoleBuilder(io.fabric8.openshift.api.model.Console instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConsoleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.Console build() {
    Console buildable = new Console(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}