package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionConfigBuilder extends ConnectionConfigFluentImpl<ConnectionConfigBuilder> implements VisitableBuilder<ConnectionConfig,io.fabric8.openshift.api.model.ConnectionConfigBuilder>{
  public ConnectionConfigBuilder() {
    this(false);
  }
  public ConnectionConfigBuilder(Boolean validationEnabled) {
    this(new ConnectionConfig(), validationEnabled);
  }
  public ConnectionConfigBuilder(ConnectionConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionConfigBuilder(io.fabric8.openshift.api.model.ConnectionConfigFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConnectionConfig(), validationEnabled);
  }
  public ConnectionConfigBuilder(io.fabric8.openshift.api.model.ConnectionConfigFluent<?> fluent,io.fabric8.openshift.api.model.ConnectionConfig instance) {
    this(fluent, instance, false);
  }
  public ConnectionConfigBuilder(io.fabric8.openshift.api.model.ConnectionConfigFluent<?> fluent,io.fabric8.openshift.api.model.ConnectionConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCa(instance.getCa()); 
    fluent.withTlsClientConfig(instance.getTlsClientConfig()); 
    fluent.withUrl(instance.getUrl()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConnectionConfigBuilder(io.fabric8.openshift.api.model.ConnectionConfig instance) {
    this(instance,false);
  }
  public ConnectionConfigBuilder(io.fabric8.openshift.api.model.ConnectionConfig instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCa(instance.getCa()); 
    this.withTlsClientConfig(instance.getTlsClientConfig()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConnectionConfigFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConnectionConfig build() {
    ConnectionConfig buildable = new ConnectionConfig(fluent.getCa(),fluent.getTlsClientConfig(),fluent.getUrl());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}