package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConfigMapBuildSourceBuilder extends ConfigMapBuildSourceFluentImpl<ConfigMapBuildSourceBuilder> implements VisitableBuilder<io.fabric8.openshift.api.model.ConfigMapBuildSource,ConfigMapBuildSourceBuilder>{
  public ConfigMapBuildSourceBuilder() {
    this(false);
  }
  public ConfigMapBuildSourceBuilder(Boolean validationEnabled) {
    this(new ConfigMapBuildSource(), validationEnabled);
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConfigMapBuildSource(), validationEnabled);
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.ConfigMapBuildSource instance) {
    this(fluent, instance, false);
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent<?> fluent,io.fabric8.openshift.api.model.ConfigMapBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigMap(instance.getConfigMap()); 
    fluent.withDestinationDir(instance.getDestinationDir()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSource instance) {
    this(instance,false);
  }
  public ConfigMapBuildSourceBuilder(io.fabric8.openshift.api.model.ConfigMapBuildSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigMap(instance.getConfigMap()); 
    this.withDestinationDir(instance.getDestinationDir()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConfigMapBuildSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConfigMapBuildSource build() {
    ConfigMapBuildSource buildable = new ConfigMapBuildSource(fluent.getConfigMap(),fluent.getDestinationDir());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}