package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConditionalUpdateBuilder extends ConditionalUpdateFluentImpl<ConditionalUpdateBuilder> implements VisitableBuilder<ConditionalUpdate,io.fabric8.openshift.api.model.ConditionalUpdateBuilder>{
  public ConditionalUpdateBuilder() {
    this(false);
  }
  public ConditionalUpdateBuilder(Boolean validationEnabled) {
    this(new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(ConditionalUpdateFluent<?> fluent) {
    this(fluent, false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ConditionalUpdate(), validationEnabled);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,io.fabric8.openshift.api.model.ConditionalUpdate instance) {
    this(fluent, instance, false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent,io.fabric8.openshift.api.model.ConditionalUpdate instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConditions(instance.getConditions()); 
    fluent.withRelease(instance.getRelease()); 
    fluent.withRisks(instance.getRisks()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdate instance) {
    this(instance,false);
  }
  public ConditionalUpdateBuilder(io.fabric8.openshift.api.model.ConditionalUpdate instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withConditions(instance.getConditions()); 
    this.withRelease(instance.getRelease()); 
    this.withRisks(instance.getRisks()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.openshift.api.model.ConditionalUpdateFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.openshift.api.model.ConditionalUpdate build() {
    ConditionalUpdate buildable = new ConditionalUpdate(fluent.getConditions(),fluent.getRelease(),fluent.getRisks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}